/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.util.ICommonTile;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.core.features.IStackSrc;
import appeng.fluids.helper.IConfigurableFluidInventory;
import appeng.fluids.util.AEFluidInventory;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.hooks.TickHandler;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class AEBaseTileEntity
extends TileEntity
implements IOrientable,
ICommonTile,
ICustomNameObject {
    private static final ThreadLocal<WeakReference<AEBaseTileEntity>> DROP_NO_ITEMS = new ThreadLocal();
    private static final Map<Class<? extends TileEntity>, IStackSrc> ITEM_STACKS = new HashMap<Class<? extends TileEntity>, IStackSrc>();
    private int renderFragment = 0;
    @Nullable
    private String customName;
    private Direction forward = Direction.NORTH;
    private Direction up = Direction.UP;
    private boolean markDirtyQueued = false;

    public AEBaseTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public static void registerTileItem(Class<? extends TileEntity> c, IStackSrc wat) {
        ITEM_STACKS.put(c, wat);
    }

    public boolean dropItems() {
        WeakReference<AEBaseTileEntity> what = DROP_NO_ITEMS.get();
        return what == null || what.get() != this;
    }

    public boolean notLoaded() {
        return !this.field_145850_b.func_175667_e(this.field_174879_c);
    }

    @Nonnull
    public TileEntity getTile() {
        return this;
    }

    @Nullable
    protected ItemStack getItemFromTile(Object obj) {
        IStackSrc src = ITEM_STACKS.get(obj.getClass());
        if (src == null) {
            return ItemStack.field_190927_a;
        }
        return src.stack(1);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.customName = data.func_74764_b("customName") ? data.func_74779_i("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = Direction.valueOf((String)data.func_74779_i("forward"));
                this.up = Direction.valueOf((String)data.func_74779_i("up"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        if (this.canBeRotated()) {
            data.func_74778_a("forward", this.getForward().name());
            data.func_74778_a("up", this.getUp().name());
        }
        if (this.customName != null) {
            data.func_74778_a("customName", this.customName);
        }
        return data;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 64, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (pkt.func_148853_f() == 64) {
            this.handleUpdateTag(null, pkt.func_148857_g());
        }
    }

    public void onReady() {
    }

    private CompoundNBT writeUpdateData() {
        CompoundNBT data = new CompoundNBT();
        PacketBuffer stream = new PacketBuffer(Unpooled.buffer());
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                return null;
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        stream.capacity(stream.readableBytes());
        data.func_74773_a("X", stream.array());
        return data;
    }

    private boolean readUpdateData(PacketBuffer stream) {
        boolean output = false;
        try {
            this.renderFragment = 100;
            output = this.readFromStream(stream);
            if ((this.renderFragment & 1) == 1) {
                output = true;
            }
            this.renderFragment = 0;
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        return output;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT data = this.writeUpdateData();
        if (data == null) {
            return new CompoundNBT();
        }
        data.func_74768_a("x", this.field_174879_c.func_177958_n());
        data.func_74768_a("y", this.field_174879_c.func_177956_o());
        data.func_74768_a("z", this.field_174879_c.func_177952_p());
        return data;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        PacketBuffer stream = new PacketBuffer(Unpooled.copiedBuffer((byte[])tag.func_74770_j("X")));
        if (this.readUpdateData(stream)) {
            this.markForUpdate();
        }
    }

    protected boolean readFromStream(PacketBuffer data) throws IOException {
        if (this.canBeRotated()) {
            Direction old_Forward = this.forward;
            Direction old_Up = this.up;
            byte orientation = data.readByte();
            this.forward = Direction.values()[orientation & 7];
            this.up = Direction.values()[orientation >> 3];
            return this.forward != old_Forward || this.up != old_Up;
        }
        return false;
    }

    protected void writeToStream(PacketBuffer data) throws IOException {
        if (this.canBeRotated()) {
            byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
            data.writeByte((int)orientation);
        }
    }

    public void markForUpdate() {
        if (this.renderFragment > 0) {
            this.renderFragment |= 1;
        } else {
            this.requestModelDataUpdate();
            if (this.field_145850_b != null && !this.func_145837_r() && !this.notLoaded()) {
                AEBaseTileBlock tileBlock;
                BlockState newState;
                boolean alreadyUpdated = false;
                BlockState currentState = this.func_195044_w();
                if (currentState.func_177230_c() instanceof AEBaseTileBlock && currentState != (newState = (tileBlock = (AEBaseTileBlock)currentState.func_177230_c()).getTileEntityBlockState(currentState, this))) {
                    AELog.blockUpdate(this.field_174879_c, currentState, newState, this);
                    this.field_145850_b.func_175656_a(this.field_174879_c, newState);
                    alreadyUpdated = true;
                }
                if (!alreadyUpdated) {
                    this.field_145850_b.func_184138_a(this.field_174879_c, currentState, currentState, 1);
                }
            }
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public Direction getForward() {
        return this.forward;
    }

    @Override
    public Direction getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
        this.saveChanges();
    }

    public void onPlacement(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (stack.func_77942_o()) {
            this.uploadSettings(SettingsFrom.DISMANTLE_ITEM, stack.func_77978_p());
        }
    }

    public void uploadSettings(SettingsFrom from, CompoundNBT compound) {
        IFluidHandler tank;
        int x;
        Object tmp;
        Object target;
        IItemHandler inv;
        IConfigManager cm;
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.func_74762_e("priority"));
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            target = (AppEngInternalAEInventory)inv;
            tmp = new AppEngInternalAEInventory(null, ((AppEngInternalAEInventory)target).getSlots());
            ((AppEngInternalAEInventory)tmp).readFromNBT(compound, "config");
            for (x = 0; x < ((AppEngInternalAEInventory)tmp).getSlots(); ++x) {
                ((AppEngInternalAEInventory)target).setStackInSlot(x, ((AppEngInternalAEInventory)tmp).getStackInSlot(x));
            }
        }
        if (this instanceof IConfigurableFluidInventory && (tank = ((IConfigurableFluidInventory)((Object)this)).getFluidInventoryByName("config")) instanceof AEFluidInventory) {
            target = (AEFluidInventory)tank;
            tmp = new AEFluidInventory(null, ((AEFluidInventory)target).getSlots());
            ((AEFluidInventory)tmp).readFromNBT(compound, "config");
            for (x = 0; x < ((AEFluidInventory)tmp).getSlots(); ++x) {
                ((AEFluidInventory)target).setFluidInSlot(x, ((AEFluidInventory)tmp).getFluidInSlot(x));
            }
        }
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
    }

    public void getNoDrops(World w, BlockPos pos, List<ItemStack> drops) {
    }

    public CompoundNBT downloadSettings(SettingsFrom from) {
        IFluidHandler tank;
        IItemHandler inv;
        IConfigManager cm;
        CompoundNBT output = new CompoundNBT();
        if (this.hasCustomInventoryName()) {
            CompoundNBT dsp = new CompoundNBT();
            dsp.func_74778_a("Name", this.customName);
            output.func_218657_a("display", (INBT)dsp);
        }
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.func_74768_a("priority", pHost.getPriority());
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
        }
        if (this instanceof IConfigurableFluidInventory && (tank = ((IConfigurableFluidInventory)((Object)this)).getFluidInventoryByName("config")) instanceof AEFluidInventory) {
            ((AEFluidInventory)tank).writeToNBT(output, "config");
        }
        return output.isEmpty() ? null : output;
    }

    @Override
    public ITextComponent getCustomInventoryName() {
        return new StringTextComponent(this.hasCustomInventoryName() ? this.customName : this.getClass().getSimpleName());
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
        this.disableDrops();
    }

    public boolean isRemote() {
        World world = this.func_145831_w();
        return world == null || world.func_201670_d();
    }

    public void disableDrops() {
        DROP_NO_ITEMS.set(new WeakReference<AEBaseTileEntity>(this));
    }

    public void saveChanges() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        } else {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (!this.markDirtyQueued) {
                TickHandler.instance().addCallable(null, this::markDirtyAtEndOfTick);
                this.markDirtyQueued = true;
            }
        }
    }

    private Object markDirtyAtEndOfTick(World w) {
        this.func_70296_d();
        this.markDirtyQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Nonnull
    public IModelData getModelData() {
        return new AEModelData(this.up, this.forward);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }
}

