/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.statistics.MENetworkChunkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayManager;
import appeng.me.GridAccessException;
import appeng.services.ChunkLoadingService;
import appeng.tile.grid.AENetworkTileEntity;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;

public class SpatialAnchorTileEntity
extends AENetworkTileEntity
implements IGridTickable,
IConfigManagerHost,
IConfigurableObject,
IOverlayDataSource {
    private final ConfigManager manager = new ConfigManager(this);
    private final Set<ChunkPos> chunks = new HashSet<ChunkPos>();
    private int powerlessTicks = 0;
    private boolean initialized = false;
    private boolean displayOverlay = false;
    private boolean isActive = false;

    public SpatialAnchorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.manager.registerSetting(Settings.OVERLAY_MODE, (Enum)YesNo.NO);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.manager.writeToNBT(data);
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.manager.readFromNBT(data);
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
        data.writeBoolean(this.displayOverlay);
        if (this.displayOverlay) {
            data.func_186865_a(this.chunks.stream().mapToLong(ChunkPos::func_201841_a).toArray());
        }
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean ret = super.readFromStream(data);
        boolean isActive = data.readBoolean();
        ret = isActive != this.isActive || ret;
        this.isActive = isActive;
        boolean newDisplayOverlay = data.readBoolean();
        ret = newDisplayOverlay != this.displayOverlay || ret;
        this.displayOverlay = newDisplayOverlay;
        this.chunks.clear();
        OverlayManager.getInstance().removeHandlers(this);
        if (this.displayOverlay) {
            this.chunks.addAll(Arrays.stream(data.func_186873_b(null)).boxed().map(c -> new ChunkPos(c.longValue())).collect(Collectors.toSet()));
            OverlayManager.getInstance().showArea(this);
        }
        return ret;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public Set<ChunkPos> getOverlayChunks() {
        return this.chunks;
    }

    @Override
    public TileEntity getOverlayTileEntity() {
        return this;
    }

    @Override
    public DimensionalCoord getOverlaySourceLocation() {
        return this.getLocation();
    }

    @Override
    public int getOverlayColor() {
        return Integer.MIN_VALUE | AEColor.TRANSPARENT.mediumVariant;
    }

    @MENetworkEventSubscribe
    public void chunkAdded(MENetworkChunkEvent.MENetworkChunkAdded changed) {
        if (changed.getWorld() == this.getServerWorld()) {
            this.force(changed.getChunkPos());
        }
    }

    @MENetworkEventSubscribe
    public void chunkRemoved(MENetworkChunkEvent.MENetworkChunkRemoved changed) {
        if (changed.getWorld() == this.getServerWorld()) {
            this.release(changed.getChunkPos(), true);
            this.wakeUp();
        }
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange powerChange) {
        this.markForUpdate();
        this.wakeUp();
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkChannelsChanged powerChange) {
        this.markForUpdate();
        this.wakeUp();
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (settingName == Settings.OVERLAY_MODE) {
            this.displayOverlay = newValue == YesNo.YES;
            this.markForUpdate();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.isRemote()) {
            OverlayManager.getInstance().removeHandlers(this);
        } else {
            this.releaseAll();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    private void wakeUp() {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(20, 20, false, true);
    }

    @Override
    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.initialized && this.getProxy().isActive() && this.getProxy().isPowered()) {
            this.forceAll();
            this.initialized = true;
        } else {
            this.cleanUp();
        }
        if (this.powerlessTicks > 200) {
            if (!this.getProxy().isPowered() || !this.getProxy().isActive()) {
                this.releaseAll();
            }
            this.powerlessTicks = 0;
            return TickRateModulation.SLEEP;
        }
        if (!this.getProxy().isPowered() || !this.getProxy().isActive()) {
            this.powerlessTicks += ticksSinceLastCall;
            return TickRateModulation.SAME;
        }
        return TickRateModulation.SLEEP;
    }

    public Set<ChunkPos> getLoadedChunks() {
        return this.chunks;
    }

    public int countLoadedChunks() {
        return this.chunks.size();
    }

    public boolean isPowered() {
        return this.getProxy().isActive() && this.getProxy().isPowered();
    }

    public boolean isActive() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            return this.isPowered();
        }
        return this.isActive;
    }

    public void registerChunk(ChunkPos chunkPos) {
        this.chunks.add(chunkPos);
        this.updatePowerConsumption();
    }

    private void updatePowerConsumption() {
        int energy = 80 + this.chunks.size() * (this.chunks.size() + 1) / 2;
        this.getProxy().setIdlePowerUsage(energy);
    }

    private void cleanUp() {
        try {
            Multiset<ChunkPos> requiredChunks = this.getProxy().getStatistics().getChunks().get(this.getServerWorld());
            Iterator<ChunkPos> iterator = this.chunks.iterator();
            while (iterator.hasNext()) {
                ChunkPos chunkPos = iterator.next();
                if (requiredChunks.contains((Object)chunkPos)) continue;
                this.release(chunkPos, false);
                iterator.remove();
            }
            for (ChunkPos chunkPos : requiredChunks) {
                if (this.chunks.contains(chunkPos)) continue;
                this.force(chunkPos);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean force(ChunkPos chunkPos) {
        if (this.func_145837_r()) {
            return false;
        }
        ServerWorld world = this.getServerWorld();
        boolean forced = ChunkLoadingService.getInstance().forceChunk(world, this.func_174877_v(), chunkPos, true);
        if (forced) {
            this.chunks.add(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return forced;
    }

    private boolean release(ChunkPos chunkPos, boolean remove) {
        ServerWorld world = this.getServerWorld();
        boolean removed = ChunkLoadingService.getInstance().releaseChunk(world, this.func_174877_v(), chunkPos, true);
        if (removed && remove) {
            this.chunks.remove(chunkPos);
        }
        this.updatePowerConsumption();
        this.markForUpdate();
        return removed;
    }

    private void forceAll() {
        try {
            for (ChunkPos chunkPos : this.getProxy().getStatistics().getChunks().get(this.getServerWorld()).elementSet()) {
                this.force(chunkPos);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void releaseAll() {
        for (ChunkPos chunk : this.chunks) {
            this.release(chunk, false);
        }
        this.chunks.clear();
    }

    private ServerWorld getServerWorld() {
        if (this.func_145831_w() instanceof ServerWorld) {
            return (ServerWorld)this.func_145831_w();
        }
        throw new IllegalStateException("Cannot be called on a client");
    }
}

