/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MeaningfulItemIterator<T extends IAEItemStack>
implements Iterator<T> {
    private final Collection<T> collection;
    private final Iterator<T> parent;
    private T next;
    private final Collection<T> toRemove = new ArrayList<T>();

    public MeaningfulItemIterator(Collection<T> collection) {
        this.collection = collection;
        this.parent = collection.iterator();
    }

    @Override
    public boolean hasNext() {
        while (this.parent.hasNext()) {
            this.next = (IAEItemStack)this.parent.next();
            if (this.next.isMeaningful()) {
                return true;
            }
            this.toRemove.add(this.next);
        }
        this.toRemove.forEach(entry -> this.collection.remove(entry));
        this.next = null;
        return false;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        this.parent.remove();
    }
}

