/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools;

import com.grim3212.assorted.tools.client.data.ToolsItemModelProvider;
import com.grim3212.assorted.tools.client.proxy.ClientProxy;
import com.grim3212.assorted.tools.common.data.ToolsBlockTagProvider;
import com.grim3212.assorted.tools.common.data.ToolsItemTagProvider;
import com.grim3212.assorted.tools.common.data.ToolsRecipes;
import com.grim3212.assorted.tools.common.enchantment.ToolsEnchantments;
import com.grim3212.assorted.tools.common.entity.ToolsEntities;
import com.grim3212.assorted.tools.common.handler.ChickenSuitConversionHandler;
import com.grim3212.assorted.tools.common.handler.EnabledCondition;
import com.grim3212.assorted.tools.common.handler.TagLoadListener;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.item.ToolsItems;
import com.grim3212.assorted.tools.common.network.PacketHandler;
import com.grim3212.assorted.tools.common.proxy.IProxy;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="assortedtools")
public class AssortedTools {
    public static final String MODID = "assortedtools";
    public static final String MODNAME = "Assorted Tools";
    public static IProxy proxy = new IProxy(){};
    public static final Logger LOGGER = LogManager.getLogger((String)"assortedtools");
    public static final ItemGroup ASSORTED_TOOLS_ITEM_GROUP = new ItemGroup("assortedtools"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ToolsItems.IRON_HAMMER.get());
        }
    };

    public AssortedTools() {
        DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
            proxy = new ClientProxy();
            return proxy;
        });
        proxy.starting();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.register((Object)new TagLoadListener());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenSuitConversionHandler());
        ToolsItems.ITEMS.register(modBus);
        ToolsEntities.ENTITIES.register(modBus);
        ToolsEnchantments.ENCHANTMENTS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ToolsConfig.COMMON_SPEC);
        CraftingHelper.register((IConditionSerializer)EnabledCondition.Serializer.INSTANCE);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            ToolsBlockTagProvider blockTagProvider = new ToolsBlockTagProvider(datagenerator, fileHelper);
            datagenerator.func_200390_a((IDataProvider)blockTagProvider);
            datagenerator.func_200390_a((IDataProvider)new ToolsItemTagProvider(datagenerator, blockTagProvider, fileHelper));
            datagenerator.func_200390_a((IDataProvider)new ToolsRecipes(datagenerator));
        }
        if (event.includeClient()) {
            datagenerator.func_200390_a((IDataProvider)new ToolsItemModelProvider(datagenerator, fileHelper));
        }
    }
}

