/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.entity;

import com.grim3212.assorted.tools.common.entity.ToolsEntities;
import com.grim3212.assorted.tools.common.item.ToolsItems;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class PokeballEntity
extends ProjectileItemEntity {
    private boolean hasEntity;
    private ItemStack currentPokeball = new ItemStack((IItemProvider)ToolsItems.POKEBALL.get(), 1);

    public PokeballEntity(EntityType<? extends PokeballEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public PokeballEntity(EntityType<? extends PokeballEntity> type, double x, double y, double z, World worldIn) {
        super(type, x, y, z, worldIn);
    }

    public PokeballEntity(LivingEntity livingEntityIn, World worldIn, ItemStack stack) {
        super((EntityType)ToolsEntities.POKEBALL.get(), livingEntityIn, worldIn);
        this.currentPokeball = stack;
        this.hasEntity = false;
        if (this.currentPokeball.func_77942_o()) {
            this.hasEntity = NBTHelper.hasTag(stack, "StoredEntity");
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            Entity hitEntity;
            EntityRayTraceResult entityResult;
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                if (this.hasEntity) {
                    Optional loadEntity = EntityType.func_220330_a((CompoundNBT)NBTHelper.getTag(this.currentPokeball, "StoredEntity"), (World)this.field_70170_p);
                    if (loadEntity.isPresent()) {
                        Entity spawnEntity = (Entity)loadEntity.get();
                        spawnEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), this.field_70177_z, 0.0f);
                        this.field_70170_p.func_217376_c(spawnEntity);
                    }
                    this.currentPokeball = new ItemStack((IItemProvider)ToolsItems.POKEBALL.get());
                }
            } else if (!(result.func_216346_c() != RayTraceResult.Type.ENTITY || (entityResult = (EntityRayTraceResult)result) == null || (hitEntity = entityResult.func_216348_a()) == null || this.hasEntity || hitEntity instanceof PlayerEntity || hitEntity instanceof EnderDragonEntity || hitEntity instanceof EnderDragonPartEntity || !(hitEntity instanceof LivingEntity))) {
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                CompoundNBT entity = livingEntity.serializeNBT();
                entity.func_74778_a("pokeball_name", livingEntity.func_200600_R().func_210760_d());
                NBTHelper.putTag(this.currentPokeball, "StoredEntity", entity);
                this.currentPokeball.func_222118_a(1, livingEntity, ent -> {});
                this.currentPokeball.func_190920_e(1);
                hitEntity.func_70106_y();
            }
            this.func_70099_a(this.currentPokeball, 0.2f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_241204_bJ_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected Item func_213885_i() {
        return (Item)ToolsItems.POKEBALL.get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

