/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.entity;

import com.grim3212.assorted.tools.common.entity.ToolsEntities;
import com.grim3212.assorted.tools.common.item.ToolsItems;
import com.grim3212.assorted.tools.common.util.SpearType;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpearEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    private SpearType spearType;
    private int bounceCount;

    public SpearEntity(EntityType<? extends AbstractArrowEntity> type, World level) {
        super(type, level);
    }

    public SpearEntity(double x, double y, double z, World level, SpearType spearType) {
        super((EntityType)ToolsEntities.SPEAR.get(), x, y, z, level);
        this.spearType = spearType;
        this.func_70239_b(this.spearType.getDamage());
    }

    public SpearEntity(LivingEntity entity, World level, SpearType spearType) {
        super((EntityType)ToolsEntities.SPEAR.get(), entity, level);
        this.spearType = spearType;
        this.func_70239_b(this.spearType.getDamage());
    }

    protected ItemStack func_184550_j() {
        switch (this.spearType) {
            case FLINT: {
                return new ItemStack((IItemProvider)ToolsItems.FLINT_SPEAR.get());
            }
            case IRON: {
                return new ItemStack((IItemProvider)ToolsItems.IRON_SPEAR.get());
            }
            case DIAMOND: {
                return new ItemStack((IItemProvider)ToolsItems.DIAMOND_SPEAR.get());
            }
            case EXPLOSIVE: {
                return new ItemStack((IItemProvider)ToolsItems.EXPLOSIVE_SPEAR.get());
            }
            case FIRE: {
                return new ItemStack((IItemProvider)ToolsItems.FIRE_SPEAR.get());
            }
            case LIGHT: {
                return new ItemStack((IItemProvider)ToolsItems.LIGHT_SPEAR.get());
            }
            case LIGHTNING: {
                return new ItemStack((IItemProvider)ToolsItems.LIGHTNING_SPEAR.get());
            }
            case SLIME: {
                return new ItemStack((IItemProvider)ToolsItems.SLIME_SPEAR.get());
            }
        }
        return new ItemStack((IItemProvider)ToolsItems.FLINT_SPEAR.get());
    }

    protected void func_213868_a(EntityRayTraceResult rayTrace) {
        super.func_213868_a(rayTrace);
        if (this.spearType == SpearType.EXPLOSIVE) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217385_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.BREAK);
            }
            this.func_70106_y();
        } else if (this.spearType == SpearType.LIGHTNING) {
            LightningBoltEntity lightningEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningEntity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)this.func_233580_cy_()));
            this.field_70170_p.func_217376_c((Entity)lightningEntity);
            this.func_70106_y();
        } else if (this.spearType == SpearType.FIRE) {
            for (int fire = 0; fire < 6; ++fire) {
                BlockPos blockPos = this.func_233580_cy_().func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockPos).func_196958_f() || !this.field_70170_p.func_180495_p(blockPos.func_177977_b()).func_200015_d((IBlockReader)this.field_70170_p, blockPos.func_177977_b())) continue;
                this.field_70170_p.func_175656_a(blockPos, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockPos));
            }
            this.func_70106_y();
        }
    }

    protected void func_230299_a_(BlockRayTraceResult rayTrace) {
        if (this.spearType == SpearType.LIGHT) {
            super.func_230299_a_(rayTrace);
            BlockState state = this.field_70170_p.func_180495_p(rayTrace.func_216350_a());
            if (rayTrace.func_216354_b() == Direction.UP) {
                if (!this.field_70170_p.field_72995_K && state.func_177230_c() != Blocks.field_150350_a && this.field_70170_p.func_180495_p(rayTrace.func_216350_a().func_177981_b(2)).func_177230_c() == Blocks.field_150350_a) {
                    this.field_70170_p.func_175656_a(rayTrace.func_216350_a().func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                }
            } else if (!this.field_70170_p.field_72995_K && state.func_177230_c() != Blocks.field_150350_a && this.field_70170_p.func_180495_p(rayTrace.func_216350_a().func_177967_a(rayTrace.func_216354_b(), 2)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(rayTrace.func_216350_a().func_177972_a(rayTrace.func_216354_b()), (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)rayTrace.func_216354_b()));
            }
            this.func_70106_y();
        } else if (this.spearType == SpearType.LIGHTNING) {
            super.func_230299_a_(rayTrace);
            LightningBoltEntity lightningEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningEntity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)this.func_233580_cy_()));
            this.field_70170_p.func_217376_c((Entity)lightningEntity);
            this.func_70106_y();
        } else if (this.spearType == SpearType.FIRE) {
            super.func_230299_a_(rayTrace);
            for (int fire = 0; fire < 6; ++fire) {
                BlockPos blockPos = rayTrace.func_216350_a().func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockPos).func_196958_f() || !AbstractFireBlock.func_241465_a_((World)this.field_70170_p, (BlockPos)blockPos, (Direction)this.func_174811_aO())) continue;
                this.field_70170_p.func_175656_a(blockPos, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockPos));
            }
            this.func_70106_y();
        } else if (this.spearType == SpearType.EXPLOSIVE) {
            super.func_230299_a_(rayTrace);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217385_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.BREAK);
            }
            this.func_70106_y();
        } else if (this.spearType == SpearType.SLIME) {
            if (this.bounceCount == 3) {
                super.func_230299_a_(rayTrace);
                this.spawnSlimeParticles();
            } else {
                ++this.bounceCount;
                Vector3d motion = this.func_213322_ci();
                this.func_213293_j(motion.field_72450_a, motion.field_72448_b * -1.0, motion.field_72449_c);
                this.field_70170_p.func_184133_a((PlayerEntity)null, this.func_233580_cy_(), SoundEvents.field_187900_fz, SoundCategory.PLAYERS, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.spawnSlimeParticles();
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            }
        } else {
            super.func_230299_a_(rayTrace);
        }
    }

    private void spawnSlimeParticles() {
        for (int j = 0; j < 8; ++j) {
            float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * 1.0f * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * 1.0f * 0.5f * f1;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197592_C, this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("SpearType", this.spearType.name());
        nbt.func_74768_a("BounceCount", this.bounceCount);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.spearType = SpearType.valueOf(nbt.func_74779_i("SpearType"));
        this.bounceCount = nbt.func_74762_e("BounceCount");
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.spearType);
        buffer.writeInt(this.bounceCount);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.spearType = (SpearType)additionalData.func_179257_a(SpearType.class);
        this.bounceCount = additionalData.readInt();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70241_g() {
        return false;
    }

    public boolean func_213873_r() {
        return false;
    }

    public void func_190547_a(LivingEntity entity, float modifier) {
    }
}

