/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.handler;

import com.grim3212.assorted.tools.common.util.ToolsArmorMaterials;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.LazyValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorMaterialHolder {
    private final String name;
    private final ForgeConfigSpec.IntValue durability;
    private final ForgeConfigSpec.IntValue enchantability;
    private final ForgeConfigSpec.DoubleValue toughness;
    private final ForgeConfigSpec.DoubleValue knockbackResistance;
    private final ForgeConfigSpec.ConfigValue<List<Integer>> reductionAmounts;
    private final LazyValue<ToolsArmorMaterials> materialRef;

    public ArmorMaterialHolder(ForgeConfigSpec.Builder builder, String name, int durability, int enchantability, double toughness, double knockbackResistance, int[] reductionAmounts, Supplier<ToolsArmorMaterials> materialRef) {
        this.name = name;
        this.materialRef = new LazyValue(materialRef);
        builder.push(name);
        this.durability = builder.comment("The durability multiplier for this armor material").defineInRange("durability", durability, 1, 100000);
        this.enchantability = builder.comment("The enchantability for this armor material").defineInRange("enchantability", enchantability, 0, 100000);
        this.toughness = builder.comment("The toughness for this armor material").defineInRange("toughness", toughness, 0.0, 100000.0);
        this.knockbackResistance = builder.comment("The knockback resistance for this armor material").defineInRange("knockbackResistance", knockbackResistance, 0.0, 100000.0);
        this.reductionAmounts = builder.comment("The reduction amounts for each piece of armor for this armor material").define("reductionAmounts", Arrays.stream(reductionAmounts).boxed().collect(Collectors.toList()));
        builder.pop();
    }

    public String getName() {
        return this.name;
    }

    public int getDurability() {
        return (Integer)this.durability.get();
    }

    public int[] getReductionAmounts() {
        return ((List)this.reductionAmounts.get()).stream().mapToInt(i -> i).toArray();
    }

    public int getEnchantability() {
        return (Integer)this.enchantability.get();
    }

    public float getToughness() {
        return ((Double)this.toughness.get()).floatValue();
    }

    public float getKnockbackResistance() {
        return ((Double)this.knockbackResistance.get()).floatValue();
    }

    public ToolsArmorMaterials getMaterial() {
        return (ToolsArmorMaterials)((Object)this.materialRef.func_179281_c());
    }

    public String toString() {
        return "[Name:" + this.getName() + ", Durability:" + this.getDurability() + ", ReductionAmounts:" + Arrays.toString(this.getReductionAmounts()) + ", Enchantability:" + this.getEnchantability() + ", Toughness:" + this.getToughness() + ", KnockbackResistance:" + this.getKnockbackResistance() + "]";
    }
}

