/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.handler;

import com.google.gson.JsonObject;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("assortedtools", "part_enabled");
    private final String part;

    public EnabledCondition(String part) {
        this.part = part;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        switch (this.part) {
            case "wands": {
                return (Boolean)ToolsConfig.COMMON.wandsEnabled.get();
            }
            case "hammers": {
                return (Boolean)ToolsConfig.COMMON.hammersEnabled.get();
            }
            case "multitools": {
                return (Boolean)ToolsConfig.COMMON.multiToolsEnabled.get();
            }
            case "boomerangs": {
                return (Boolean)ToolsConfig.COMMON.boomerangsEnabled.get();
            }
            case "pokeball": {
                return (Boolean)ToolsConfig.COMMON.pokeballEnabled.get();
            }
            case "chickensuit": {
                return (Boolean)ToolsConfig.COMMON.chickenSuitEnabled.get();
            }
            case "extramaterials": {
                return (Boolean)ToolsConfig.COMMON.extraMaterialsEnabled.get();
            }
            case "spears": {
                return (Boolean)ToolsConfig.COMMON.spearsEnabled.get();
            }
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EnabledCondition value) {
            json.addProperty("part", value.part);
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"part"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

