/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.handler;

import com.grim3212.assorted.tools.common.util.ToolsItemTier;
import net.minecraft.item.IItemTier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemTierHolder {
    private final String name;
    private final IItemTier defaultTier;
    private final ForgeConfigSpec.IntValue harvestLevel;
    private final ForgeConfigSpec.IntValue maxUses;
    private final ForgeConfigSpec.IntValue enchantability;
    private final ForgeConfigSpec.DoubleValue efficiency;
    private final ForgeConfigSpec.DoubleValue damage;
    protected final ForgeConfigSpec.DoubleValue axeDamage;
    protected final ForgeConfigSpec.DoubleValue axeSpeed;

    public ItemTierHolder(ForgeConfigSpec.Builder builder, String name, IItemTier defaultTier, float defaultAxeDamage, float defaultAxeSpeed) {
        this.name = name;
        this.defaultTier = defaultTier;
        builder.push(name);
        this.maxUses = builder.comment("The maximum uses for this item tier").defineInRange("maxUses", this.defaultTier.func_200926_a(), 1, 100000);
        this.enchantability = builder.comment("The enchantability for this item tier").defineInRange("enchantability", this.defaultTier.func_200927_e(), 0, 100000);
        this.harvestLevel = builder.comment("The harvest level for this item tier").defineInRange("harvestLevel", this.defaultTier.func_200925_d(), 0, 100);
        this.efficiency = builder.comment("The efficiency for this item tier").defineInRange("efficiency", (double)this.defaultTier.func_200928_b(), 0.0, 100000.0);
        this.damage = builder.comment("The amount of damage this item tier does").defineInRange("damage", (double)this.defaultTier.func_200929_c(), 0.0, 100000.0);
        this.axeDamage = builder.comment("The damage modifier for axes as they are different per material. Will not affect vanilla tools.").defineInRange("axeDamage", (double)defaultAxeDamage, 0.0, 100000.0);
        this.axeSpeed = builder.comment("The speed modifier for axes as they are different per material. Will not affect vanilla tools.").defineInRange("axeSpeed", (double)defaultAxeSpeed, 0.0, 100000.0);
        builder.pop();
    }

    public ItemTierHolder(ForgeConfigSpec.Builder builder, String name, ToolsItemTier defaultTier) {
        this.name = name;
        this.defaultTier = defaultTier;
        builder.push(name);
        this.maxUses = builder.comment("The maximum uses for this item tier").defineInRange("maxUses", this.defaultTier.func_200926_a(), 1, 100000);
        this.enchantability = builder.comment("The enchantability for this item tier").defineInRange("enchantability", this.defaultTier.func_200927_e(), 0, 100000);
        this.harvestLevel = builder.comment("The harvest level for this item tier").defineInRange("harvestLevel", this.defaultTier.func_200925_d(), 0, 100);
        this.efficiency = builder.comment("The efficiency for this item tier").defineInRange("efficiency", (double)this.defaultTier.func_200928_b(), 0.0, 100000.0);
        this.damage = builder.comment("The amount of damage this item tier does").defineInRange("damage", (double)this.defaultTier.func_200929_c(), 0.0, 100000.0);
        this.axeDamage = builder.comment("The damage modifier for axes as they are different per material. Will not affect vanilla tools.").defineInRange("axeDamage", (double)defaultTier.getAxeDamage(), 0.0, 100000.0);
        this.axeSpeed = builder.comment("The speed modifier for axes as they are different per material. Will not affect vanilla tools.").defineInRange("axeSpeed", (double)defaultTier.getAxeSpeedIn(), 0.0, 100000.0);
        builder.pop();
    }

    protected void extraConfigs(ForgeConfigSpec.Builder builder) {
    }

    public String getName() {
        return this.name;
    }

    public IItemTier getDefaultTier() {
        return this.defaultTier;
    }

    public int getHarvestLevel() {
        return (Integer)this.harvestLevel.get();
    }

    public int getMaxUses() {
        return (Integer)this.maxUses.get();
    }

    public float getEfficiency() {
        return ((Double)this.efficiency.get()).floatValue();
    }

    public float getDamage() {
        return ((Double)this.damage.get()).floatValue();
    }

    public int getEnchantability() {
        return (Integer)this.enchantability.get();
    }

    public float getAxeDamage() {
        return ((Double)this.axeDamage.get()).floatValue();
    }

    public float getAxeSpeed() {
        return ((Double)this.axeSpeed.get()).floatValue();
    }

    public String toString() {
        return "[Name:" + this.getName() + ", HarvestLevel:" + this.getHarvestLevel() + ", MaxUses:" + this.getMaxUses() + ", Efficiency:" + this.getEfficiency() + ", Damage:" + this.getDamage() + ", Enchantability:" + this.getEnchantability() + ", AxeDamage:" + this.getAxeDamage() + ", AxeSpeed:" + this.getAxeSpeed() + "]";
    }
}

