/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.grim3212.assorted.tools.common.handler.ArmorMaterialHolder;
import com.grim3212.assorted.tools.common.handler.ItemTierHolder;
import com.grim3212.assorted.tools.common.handler.ModdedItemTierHolder;
import com.grim3212.assorted.tools.common.util.ConfigurableBlockStates;
import com.grim3212.assorted.tools.common.util.ToolsArmorMaterials;
import com.grim3212.assorted.tools.common.util.ToolsItemTier;
import java.util.List;
import java.util.Map;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemTier;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class ToolsConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue turnAroundItem;
        public final ForgeConfigSpec.BooleanValue turnAroundMob;
        public final ForgeConfigSpec.BooleanValue breaksTorches;
        public final ForgeConfigSpec.BooleanValue breaksPlants;
        public final ForgeConfigSpec.BooleanValue hitsButtons;
        public final ForgeConfigSpec.BooleanValue turnAroundButton;
        public final ForgeConfigSpec.IntValue woodBoomerangRange;
        public final ForgeConfigSpec.IntValue woodBoomerangDamage;
        public final ForgeConfigSpec.IntValue diamondBoomerangRange;
        public final ForgeConfigSpec.IntValue diamondBoomerangDamage;
        public final ForgeConfigSpec.BooleanValue diamondBoomerangFollows;
        public final ForgeConfigSpec.BooleanValue freeBuildMode;
        public final ForgeConfigSpec.BooleanValue bedrockBreaking;
        public final ForgeConfigSpec.BooleanValue easyMiningObsidian;
        public final ForgeConfigSpec.ConfigValue<List<String>> destructiveWandSparedBlocks;
        public final ForgeConfigSpec.ConfigValue<List<String>> miningWandBlocksForSurfaceMining;
        public final ArmorMaterialHolder chickenSuitArmorMaterial;
        public final ItemTierHolder woodItemTier;
        public final ItemTierHolder stoneItemTier;
        public final ItemTierHolder goldItemTier;
        public final ItemTierHolder ironItemTier;
        public final ItemTierHolder diamondItemTier;
        public final ItemTierHolder netheriteItemTier;
        public final Map<String, ModdedItemTierHolder> moddedTiers = Maps.newHashMap();
        public final Map<String, ArmorMaterialHolder> moddedArmors = Maps.newHashMap();
        public ConfigurableBlockStates destructiveSparedBlocks;
        public ConfigurableBlockStates miningSurfaceBlocks;
        public final ForgeConfigSpec.BooleanValue wandsEnabled;
        public final ForgeConfigSpec.BooleanValue boomerangsEnabled;
        public final ForgeConfigSpec.BooleanValue hammersEnabled;
        public final ForgeConfigSpec.BooleanValue multiToolsEnabled;
        public final ForgeConfigSpec.BooleanValue pokeballEnabled;
        public final ForgeConfigSpec.BooleanValue chickenSuitEnabled;
        public final ForgeConfigSpec.BooleanValue extraMaterialsEnabled;
        public final ForgeConfigSpec.BooleanValue spearsEnabled;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Parts");
            this.wandsEnabled = builder.comment("Set this to true if you would like wands to be craftable and found in the creative tab.").define("wandsEnabled", true);
            this.boomerangsEnabled = builder.comment("Set this to true if you would like boomerangs to be craftable and found in the creative tab.").define("boomerangsEnabled", true);
            this.hammersEnabled = builder.comment("Set this to true if you would like hammers to be craftable and found in the creative tab.").define("hammersEnabled", true);
            this.multiToolsEnabled = builder.comment("Set this to true if you would like multitools to be craftable and found in the creative tab.").define("multiToolsEnabled", true);
            this.pokeballEnabled = builder.comment("Set this to true if you would like the pokeball to be craftable and found in the creative tab.").define("pokeballEnabled", true);
            this.chickenSuitEnabled = builder.comment("Set this to true if you would like the chicken suit to be craftable and found in the creative tab as well as if you want the Chicken Jump enchantment to be able to be applied.").define("chickenSuitEnabled", true);
            this.extraMaterialsEnabled = builder.comment("Set this to true if you would like to enable support for crafting the extra tools and armor that this supports. For example, Steel, Copper, or Ruby tools and armor.").define("extraMaterialsEnabled", true);
            this.spearsEnabled = builder.comment("Set this to true if you would like the spears to be craftable and found in the creative tab.").define("spearsEnabled", true);
            builder.pop();
            builder.push("Boomerangs");
            this.turnAroundItem = builder.comment("Set this to true if you would like boomerangs to turn around after they have picked up items.").define("turnAroundItem", false);
            this.turnAroundMob = builder.comment("Set this to true if you would like boomerangs to turn around after they have hit a mob.").define("turnAroundMob", false);
            this.turnAroundButton = builder.comment("Set this to false if you would like boomerangs to not turn around after they have hit a button or a lever.").define("turnAroundButton", true);
            this.breaksTorches = builder.comment("Set this to true if you would like boomerangs to be able to break torches.").define("breaksTorches", false);
            this.breaksPlants = builder.comment("Set this to true if you would like boomerangs to be able to break plants.").define("breaksPlants", false);
            this.hitsButtons = builder.comment("Set this to false if you would like boomerangs to not be able to hit buttons or levers.").define("hitsButtons", true);
            this.woodBoomerangRange = builder.comment("The maximum range away from the player the wood boomerang will travel before turning around.").defineInRange("woodBoomerangRange", 20, 1, 200);
            this.woodBoomerangDamage = builder.comment("The amount of damage the wood boomerang does to mobs.").defineInRange("woodBoomerangDamage", 1, 1, 500);
            this.diamondBoomerangRange = builder.comment("The maximum range away from the player the diamond boomerang will travel before turning around.").defineInRange("diamondBoomerangRange", 30, 1, 200);
            this.diamondBoomerangDamage = builder.comment("The amount of damage the diamond boomerang does to mobs.").defineInRange("diamondBoomerangDamage", 5, 1, 500);
            this.diamondBoomerangFollows = builder.comment("Set to true if you would like the diamond boomerang to follow where the player is looking.").define("diamondBoomerangFollows", false);
            builder.pop();
            builder.push("Wands");
            this.freeBuildMode = builder.comment("Set to true if you would like the wands to not require any blocks to build with.").define("freeBuildMode", false);
            this.bedrockBreaking = builder.comment("Set to true if you would like the breaking wands to be able to break bedrock.").define("bedrockBreaking", false);
            this.easyMiningObsidian = builder.comment("Set to true if you would like the mining wands to be able to mine obsidian.").define("easyMiningObsidian", false);
            this.destructiveWandSparedBlocks = builder.comment("A list of blocks that the wand breaking wand will not break. Usually used for ores.").define("destructiveWandSparedBlocks", (Object)Lists.newArrayList((Object[])new String[]{"tag|forge:ores", "tag|forge:chests", "block|minecraft:spawner"}));
            this.miningWandBlocksForSurfaceMining = builder.comment("A list of blocks that the mining wand can break from the surface.").define("miningWandBlocksForSurfaceMining", (Object)Lists.newArrayList((Object[])new String[]{"tag|forge:ores"}));
            builder.pop();
            builder.push("Armors");
            this.chickenSuitArmorMaterial = new ArmorMaterialHolder(builder, "chicken_suit", 5, 15, 0.0, 0.0, new int[]{1, 2, 3, 1}, () -> ToolsArmorMaterials.CHICKEN_SUIT);
            this.moddedArmors.clear();
            this.moddedArmors.put("tin", new ArmorMaterialHolder(builder, "tin", 8, 14, 0.0, 0.0, new int[]{1, 3, 5, 2}, () -> ToolsArmorMaterials.TIN));
            this.moddedArmors.put("copper", new ArmorMaterialHolder(builder, "copper", 11, 14, 0.0, 0.0, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.COPPER));
            this.moddedArmors.put("silver", new ArmorMaterialHolder(builder, "silver", 27, 14, 0.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.SILVER));
            this.moddedArmors.put("aluminum", new ArmorMaterialHolder(builder, "aluminum", 13, 10, 0.0, 0.0, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.ALUMINUM));
            this.moddedArmors.put("nickel", new ArmorMaterialHolder(builder, "nickel", 13, 10, 0.0, 0.0, new int[]{2, 3, 4, 2}, () -> ToolsArmorMaterials.NICKEL));
            this.moddedArmors.put("platinum", new ArmorMaterialHolder(builder, "platinum", 36, 18, 3.0, 0.2f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.PLATINUM));
            this.moddedArmors.put("lead", new ArmorMaterialHolder(builder, "lead", 13, 4, 0.0, 0.0, new int[]{2, 3, 4, 2}, () -> ToolsArmorMaterials.LEAD));
            this.moddedArmors.put("bronze", new ArmorMaterialHolder(builder, "bronze", 14, 13, 0.0, 0.1f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.BRONZE));
            this.moddedArmors.put("electrum", new ArmorMaterialHolder(builder, "electrum", 13, 13, 0.0, 0.0, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.ELECTRUM));
            this.moddedArmors.put("invar", new ArmorMaterialHolder(builder, "invar", 15, 11, 0.2f, 0.1f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.INVAR));
            this.moddedArmors.put("steel", new ArmorMaterialHolder(builder, "steel", 26, 10, 0.5, 0.3f, new int[]{2, 6, 7, 2}, () -> ToolsArmorMaterials.STEEL));
            this.moddedArmors.put("ruby", new ArmorMaterialHolder(builder, "ruby", 34, 10, 2.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.RUBY));
            this.moddedArmors.put("amethyst", new ArmorMaterialHolder(builder, "amethyst", 31, 14, 1.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.AMETHYST));
            this.moddedArmors.put("sapphire", new ArmorMaterialHolder(builder, "sapphire", 31, 14, 1.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.SAPPHIRE));
            this.moddedArmors.put("topaz", new ArmorMaterialHolder(builder, "topaz", 30, 8, 1.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.TOPAZ));
            this.moddedArmors.put("emerald", new ArmorMaterialHolder(builder, "emerald", 32, 14, 2.0, 0.0, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.EMERALD));
            builder.pop();
            builder.push("Item Tiers");
            builder.comment(new String[]{"These are used by Hammers and MultiTools to allow you to override the default vanilla values that they use.", "These will not change the values that vanilla tools use."});
            builder.push("Vanilla Overrides");
            this.woodItemTier = new ItemTierHolder(builder, "wood", (IItemTier)ItemTier.WOOD, 6.0f, -3.2f);
            this.stoneItemTier = new ItemTierHolder(builder, "stone", (IItemTier)ItemTier.STONE, 7.0f, -3.2f);
            this.goldItemTier = new ItemTierHolder(builder, "gold", (IItemTier)ItemTier.GOLD, 6.0f, -3.0f);
            this.ironItemTier = new ItemTierHolder(builder, "iron", (IItemTier)ItemTier.IRON, 6.0f, -3.1f);
            this.diamondItemTier = new ItemTierHolder(builder, "diamond", (IItemTier)ItemTier.DIAMOND, 5.0f, -3.0f);
            this.netheriteItemTier = new ItemTierHolder(builder, "netherite", (IItemTier)ItemTier.NETHERITE, 5.0f, -3.0f);
            builder.pop();
            builder.comment("These are used by Hammers, MultiTools, and the normal tool sets to allow you to override the default values that are used.");
            builder.push("Modded Overrides");
            this.moddedTiers.clear();
            this.moddedTiers.put("tin", new ModdedItemTierHolder(builder, "tin", ToolsItemTier.TIN));
            this.moddedTiers.put("copper", new ModdedItemTierHolder(builder, "copper", ToolsItemTier.COPPER));
            this.moddedTiers.put("silver", new ModdedItemTierHolder(builder, "silver", ToolsItemTier.SILVER));
            this.moddedTiers.put("aluminum", new ModdedItemTierHolder(builder, "aluminum", ToolsItemTier.ALUMINUM));
            this.moddedTiers.put("nickel", new ModdedItemTierHolder(builder, "nickel", ToolsItemTier.NICKEL));
            this.moddedTiers.put("platinum", new ModdedItemTierHolder(builder, "platinum", ToolsItemTier.PLATINUM));
            this.moddedTiers.put("lead", new ModdedItemTierHolder(builder, "lead", ToolsItemTier.LEAD));
            this.moddedTiers.put("bronze", new ModdedItemTierHolder(builder, "bronze", ToolsItemTier.BRONZE));
            this.moddedTiers.put("electrum", new ModdedItemTierHolder(builder, "electrum", ToolsItemTier.ELECTRUM));
            this.moddedTiers.put("invar", new ModdedItemTierHolder(builder, "invar", ToolsItemTier.INVAR));
            this.moddedTiers.put("steel", new ModdedItemTierHolder(builder, "steel", ToolsItemTier.STEEL));
            this.moddedTiers.put("ruby", new ModdedItemTierHolder(builder, "ruby", ToolsItemTier.RUBY));
            this.moddedTiers.put("amethyst", new ModdedItemTierHolder(builder, "amethyst", ToolsItemTier.AMETHYST));
            this.moddedTiers.put("sapphire", new ModdedItemTierHolder(builder, "sapphire", ToolsItemTier.SAPPHIRE));
            this.moddedTiers.put("topaz", new ModdedItemTierHolder(builder, "topaz", ToolsItemTier.TOPAZ));
            this.moddedTiers.put("emerald", new ModdedItemTierHolder(builder, "emerald", ToolsItemTier.EMERALD));
            builder.pop();
            builder.pop();
        }

        public void init() {
            this.destructiveSparedBlocks = new ConfigurableBlockStates.Builder().processString((List)this.destructiveWandSparedBlocks.get()).build();
            this.miningSurfaceBlocks = new ConfigurableBlockStates.Builder().processString((List)this.miningWandBlocksForSurfaceMining.get()).build();
        }
    }
}

