/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.grim3212.assorted.tools.AssortedTools;
import com.grim3212.assorted.tools.common.entity.PokeballEntity;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PokeballItem
extends Item {
    public PokeballItem(Item.Properties properties) {
        super(properties.func_200918_c(10));
    }

    protected boolean func_194125_a(ItemGroup group) {
        return (Boolean)ToolsConfig.COMMON.pokeballEnabled.get() != false ? super.func_194125_a(group) : false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            PokeballEntity pokeball = new PokeballEntity((LivingEntity)playerIn, worldIn, itemStackIn.func_77946_l());
            pokeball.func_70186_c(playerIn.func_70040_Z().field_72450_a, playerIn.func_70040_Z().field_72448_b, playerIn.func_70040_Z().field_72449_c, 1.5f, 1.0f);
            worldIn.func_217376_c((Entity)pokeball);
        }
        worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (Item.field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!playerIn.func_184812_l_() || NBTHelper.hasTag(itemStackIn, "StoredEntity")) {
            return ActionResult.func_226248_a_((Object)ItemStack.field_190927_a);
        }
        return ActionResult.func_226248_a_((Object)itemStackIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (NBTHelper.hasTag(stack, "StoredEntity")) {
            CompoundNBT stored = NBTHelper.getTag(stack, "StoredEntity");
            String entityName = stored.func_74779_i("id");
            if (stored.func_74764_b("pokeball_name")) {
                entityName = stored.func_74779_i("pokeball_name");
            }
            if (stored.func_74764_b("CustomName")) {
                String s = stored.func_74779_i("CustomName");
                try {
                    IFormattableTextComponent customName = ITextComponent.Serializer.func_240643_a_((String)stored.func_74779_i("CustomName"));
                    customName.func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC});
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pokeball.stored_custom_name", new Object[]{customName, new TranslationTextComponent(entityName).func_240699_a_(TextFormatting.AQUA)}));
                }
                catch (Exception exception) {
                    AssortedTools.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pokeball.stored", new Object[]{new TranslationTextComponent(entityName).func_240699_a_(TextFormatting.AQUA)}));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pokeball.stored", new Object[]{new TranslationTextComponent(entityName).func_240699_a_(TextFormatting.AQUA)}));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pokeball.empty").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

