/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.grim3212.assorted.tools.common.entity.SpearEntity;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.util.SpearType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class SpearItem
extends Item {
    private final SpearType type;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public SpearItem(Item.Properties props, SpearType type) {
        super(props.func_200917_a(16));
        this.type = type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.type.getItemDamage(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    protected boolean func_194125_a(ItemGroup group) {
        return (Boolean)ToolsConfig.COMMON.spearsEnabled.get() != false ? super.func_194125_a(group) : false;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        level.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!level.field_72995_K) {
            SpearEntity spear = new SpearEntity((LivingEntity)player, level, this.type);
            spear.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.type == SpearType.SLIME ? 1.4f : 1.4f + (float)(this.type.getDamage() / 2.0), 1.2f);
            level.func_217376_c((Entity)spear);
        }
        if (!player.func_184812_l_()) {
            player.func_184586_b(hand).func_190918_g(1);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(slot);
    }
}

