/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Maps;
import com.grim3212.assorted.tools.AssortedTools;
import com.grim3212.assorted.tools.common.handler.ArmorMaterialHolder;
import com.grim3212.assorted.tools.common.handler.ModdedItemTierHolder;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.item.BoomerangItem;
import com.grim3212.assorted.tools.common.item.ChickenSuitArmor;
import com.grim3212.assorted.tools.common.item.HammerItem;
import com.grim3212.assorted.tools.common.item.MaterialArmorItem;
import com.grim3212.assorted.tools.common.item.MaterialAxeItem;
import com.grim3212.assorted.tools.common.item.MaterialHoeItem;
import com.grim3212.assorted.tools.common.item.MaterialPickaxeItem;
import com.grim3212.assorted.tools.common.item.MaterialShovelItem;
import com.grim3212.assorted.tools.common.item.MaterialSwordItem;
import com.grim3212.assorted.tools.common.item.MultiToolItem;
import com.grim3212.assorted.tools.common.item.PokeballItem;
import com.grim3212.assorted.tools.common.item.SpearItem;
import com.grim3212.assorted.tools.common.item.WandBreakingItem;
import com.grim3212.assorted.tools.common.item.WandBuildingItem;
import com.grim3212.assorted.tools.common.item.WandMiningItem;
import com.grim3212.assorted.tools.common.item.configurable.ConfigurableArmorItem;
import com.grim3212.assorted.tools.common.util.SpearType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ToolsItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"assortedtools");
    public static final RegistryObject<HammerItem> NETHERITE_HAMMER = ToolsItems.register("netherite_hammer", () -> new HammerItem(ToolsConfig.COMMON.netheriteItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<HammerItem> DIAMOND_HAMMER = ToolsItems.register("diamond_hammer", () -> new HammerItem(ToolsConfig.COMMON.diamondItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<HammerItem> GOLD_HAMMER = ToolsItems.register("gold_hammer", () -> new HammerItem(ToolsConfig.COMMON.goldItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<HammerItem> IRON_HAMMER = ToolsItems.register("iron_hammer", () -> new HammerItem(ToolsConfig.COMMON.ironItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<HammerItem> STONE_HAMMER = ToolsItems.register("stone_hammer", () -> new HammerItem(ToolsConfig.COMMON.stoneItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<HammerItem> WOOD_HAMMER = ToolsItems.register("wood_hammer", () -> new HammerItem(ToolsConfig.COMMON.woodItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<BoomerangItem> WOOD_BOOMERANG = ToolsItems.register("wood_boomerang", () -> new BoomerangItem(true, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP).func_200917_a(1)));
    public static final RegistryObject<BoomerangItem> DIAMOND_BOOMERANG = ToolsItems.register("diamond_boomerang", () -> new BoomerangItem(false, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP).func_200917_a(1)));
    public static final RegistryObject<WandBuildingItem> BUILDING_WAND = ToolsItems.register("building_wand", () -> new WandBuildingItem(false, new Item.Properties().func_200918_c(30)));
    public static final RegistryObject<WandBuildingItem> REINFORCED_BUILDING_WAND = ToolsItems.register("reinforced_building_wand", () -> new WandBuildingItem(true, new Item.Properties().func_200918_c(200)));
    public static final RegistryObject<WandBreakingItem> BREAKING_WAND = ToolsItems.register("breaking_wand", () -> new WandBreakingItem(false, new Item.Properties().func_200918_c(15)));
    public static final RegistryObject<WandBreakingItem> REINFORCED_BREAKING_WAND = ToolsItems.register("reinforced_breaking_wand", () -> new WandBreakingItem(true, new Item.Properties().func_200918_c(120)));
    public static final RegistryObject<WandMiningItem> MINING_WAND = ToolsItems.register("mining_wand", () -> new WandMiningItem(false, new Item.Properties().func_200918_c(15)));
    public static final RegistryObject<WandMiningItem> REINFORCED_MINING_WAND = ToolsItems.register("reinforced_mining_wand", () -> new WandMiningItem(true, new Item.Properties().func_200918_c(120)));
    public static final RegistryObject<ChickenSuitArmor> CHICKEN_SUIT_HELMET = ToolsItems.register("chicken_suit_helmet", () -> new ChickenSuitArmor(EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<ChickenSuitArmor> CHICKEN_SUIT_CHESTPLATE = ToolsItems.register("chicken_suit_chestplate", () -> new ChickenSuitArmor(EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<ChickenSuitArmor> CHICKEN_SUIT_LEGGINGS = ToolsItems.register("chicken_suit_leggings", () -> new ChickenSuitArmor(EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<ChickenSuitArmor> CHICKEN_SUIT_BOOTS = ToolsItems.register("chicken_suit_boots", () -> new ChickenSuitArmor(EquipmentSlotType.FEET, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<PokeballItem> POKEBALL = ToolsItems.register("pokeball", () -> new PokeballItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> WOODEN_MULTITOOL = ToolsItems.register("wooden_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.woodItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> STONE_MULTITOOL = ToolsItems.register("stone_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.stoneItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> GOLDEN_MULTITOOL = ToolsItems.register("golden_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.goldItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> IRON_MULTITOOL = ToolsItems.register("iron_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.ironItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> DIAMOND_MULTITOOL = ToolsItems.register("diamond_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.diamondItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<MultiToolItem> NETHERITE_MULTITOOL = ToolsItems.register("netherite_multitool", () -> new MultiToolItem(ToolsConfig.COMMON.netheriteItemTier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
    public static final RegistryObject<SpearItem> FLINT_SPEAR = ToolsItems.register("flint_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.FLINT));
    public static final RegistryObject<SpearItem> IRON_SPEAR = ToolsItems.register("iron_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.IRON));
    public static final RegistryObject<SpearItem> DIAMOND_SPEAR = ToolsItems.register("diamond_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.DIAMOND));
    public static final RegistryObject<SpearItem> EXPLOSIVE_SPEAR = ToolsItems.register("explosive_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.EXPLOSIVE));
    public static final RegistryObject<SpearItem> FIRE_SPEAR = ToolsItems.register("fire_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.FIRE));
    public static final RegistryObject<SpearItem> LIGHT_SPEAR = ToolsItems.register("light_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.LIGHT));
    public static final RegistryObject<SpearItem> LIGHTNING_SPEAR = ToolsItems.register("lightning_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.LIGHTNING));
    public static final RegistryObject<SpearItem> SLIME_SPEAR = ToolsItems.register("slime_spear", () -> new SpearItem(new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), SpearType.SLIME));
    public static final Map<String, MaterialGroup> MATERIAL_GROUPS = Maps.newHashMap();

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ITEMS.register(name, sup);
    }

    static {
        ToolsConfig.COMMON.moddedTiers.forEach((s, tier) -> MATERIAL_GROUPS.put((String)s, new MaterialGroup((ModdedItemTierHolder)tier, ToolsConfig.COMMON.moddedArmors.get(s))));
    }

    public static final class MaterialGroup {
        public final RegistryObject<MaterialPickaxeItem> PICKAXE;
        public final RegistryObject<MaterialShovelItem> SHOVEL;
        public final RegistryObject<MaterialAxeItem> AXE;
        public final RegistryObject<MaterialHoeItem> HOE;
        public final RegistryObject<MaterialSwordItem> SWORD;
        public final RegistryObject<HammerItem> HAMMER;
        public final RegistryObject<MultiToolItem> MULTITOOL;
        public final RegistryObject<ConfigurableArmorItem> HELMET;
        public final RegistryObject<ConfigurableArmorItem> CHESTPLATE;
        public final RegistryObject<ConfigurableArmorItem> LEGGINGS;
        public final RegistryObject<ConfigurableArmorItem> BOOTS;
        public final ITag<Item> material;

        public MaterialGroup(ModdedItemTierHolder tier, ArmorMaterialHolder armor) {
            this.PICKAXE = ToolsItems.register(tier.getName() + "_pickaxe", () -> new MaterialPickaxeItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.SHOVEL = ToolsItems.register(tier.getName() + "_shovel", () -> new MaterialShovelItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.AXE = ToolsItems.register(tier.getName() + "_axe", () -> new MaterialAxeItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.HOE = ToolsItems.register(tier.getName() + "_hoe", () -> new MaterialHoeItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.SWORD = ToolsItems.register(tier.getName() + "_sword", () -> new MaterialSwordItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.HAMMER = ToolsItems.register(tier.getName() + "_hammer", () -> new HammerItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), true));
            this.MULTITOOL = ToolsItems.register(tier.getName() + "_multitool", () -> new MultiToolItem(tier, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP), true));
            if (armor == null) {
                throw new NullPointerException("Got null ArmorMaterialHolder when registering Extra Materials");
            }
            this.HELMET = ToolsItems.register(tier.getName() + "_helmet", () -> new MaterialArmorItem(armor.getMaterial(), EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.CHESTPLATE = ToolsItems.register(tier.getName() + "_chestplate", () -> new MaterialArmorItem(armor.getMaterial(), EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.LEGGINGS = ToolsItems.register(tier.getName() + "_leggings", () -> new MaterialArmorItem(armor.getMaterial(), EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.BOOTS = ToolsItems.register(tier.getName() + "_boots", () -> new MaterialArmorItem(armor.getMaterial(), EquipmentSlotType.FEET, new Item.Properties().func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP)));
            this.material = tier.getMaterial();
        }
    }
}

