/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.item.WandItem;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import com.grim3212.assorted.tools.common.util.WandCoord3D;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WandBreakingItem
extends WandItem {
    public WandBreakingItem(boolean reinforced, Item.Properties props) {
        super(reinforced, props);
    }

    protected static boolean isOre(BlockState state) {
        return ToolsConfig.COMMON.destructiveSparedBlocks.getLoadedStates().contains((Object)state);
    }

    @Override
    protected boolean canBreak(World worldIn, BlockPos pos, ItemStack stack) {
        BlockState state = worldIn.func_180495_p(pos);
        switch (BreakingMode.fromString(NBTHelper.getString(stack, "Mode"))) {
            case BREAK_WEAK: {
                return state.func_185904_a().func_76222_j() || state.func_185904_a().func_186274_m() == PushReaction.DESTROY || state.func_185904_a().func_76224_d();
            }
            case BREAK_ALL: {
                return state.func_177230_c() != Blocks.field_150357_h || (Boolean)ToolsConfig.COMMON.bedrockBreaking.get() != false;
            }
            case BREAK_XORES: {
                return (state.func_177230_c() != Blocks.field_150357_h || (Boolean)ToolsConfig.COMMON.bedrockBreaking.get() != false) && !WandBreakingItem.isOre(state);
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2d, ItemStack stack) {
        return range - 250 > maxDiff;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{0.5, 0.5, 0.5};
    }

    @Override
    protected boolean doEffect(World world, PlayerEntity entityplayer, Hand hand, WandCoord3D start, WandCoord3D end, BlockState state) {
        boolean damage = this.doBreaking(world, start, end, entityplayer, hand);
        if (damage) {
            world.func_184133_a((PlayerEntity)null, end.pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 2.5f, 0.5f + world.field_73012_v.nextFloat() * 0.3f);
        }
        return damage;
    }

    private boolean doBreaking(World world, WandCoord3D start, WandCoord3D end, PlayerEntity entityplayer, Hand hand) {
        BlockState stateAt;
        BlockPos newPos;
        int Z;
        int Y;
        int X;
        int cnt = 0;
        for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                    newPos = new BlockPos(X, Y, Z);
                    stateAt = world.func_180495_p(newPos);
                    if (stateAt.func_177230_c() == Blocks.field_150350_a || !this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                    ++cnt;
                }
            }
        }
        if (cnt == 0) {
            if (!world.field_72995_K) {
                this.error(entityplayer, end, "nowork");
            }
            return false;
        }
        for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                    newPos = new BlockPos(X, Y, Z);
                    stateAt = world.func_180495_p(newPos);
                    if (stateAt.func_177230_c() == Blocks.field_150350_a || !this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                    stateAt.func_177230_c().func_176208_a(world, newPos, stateAt, entityplayer);
                    world.func_175656_a(newPos, Blocks.field_150350_a.func_176223_P());
                    if (this.rand.nextInt(cnt / 50 + 1) != 0) continue;
                    this.particles(world, newPos, 1);
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack cycleMode(PlayerEntity player, ItemStack stack) {
        BreakingMode mode = BreakingMode.fromString(NBTHelper.getString(stack, "Mode"));
        BreakingMode next = BreakingMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString(stack, "Mode", next.func_176610_l());
        this.sendMessage(player, (ITextComponent)new TranslationTextComponent("assortedtools.wand.switched", new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.putString(stack, "Mode", BreakingMode.BREAK_WEAK.func_176610_l());
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BreakingMode mode = BreakingMode.fromString(NBTHelper.getString(stack, "Mode"));
        if (mode != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.wand.current", new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.broken"));
        }
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        NBTHelper.putString(stack, "Mode", BreakingMode.BREAK_WEAK.func_176610_l());
    }

    private static enum BreakingMode implements IStringSerializable
    {
        BREAK_WEAK("breakweak", 0),
        BREAK_ALL("breakall", 1),
        BREAK_XORES("breakxores", 2);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<BreakingMode> values;
        private static final List<BreakingMode> notReinforced;

        private BreakingMode(String name, int order) {
            this(name, order, false);
        }

        private BreakingMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static BreakingMode getNext(BreakingMode current, ItemStack stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static BreakingMode fromString(String type) {
            for (BreakingMode mode : values) {
                if (!mode.func_176610_l().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String func_176610_l() {
            return this.name;
        }

        public TranslationTextComponent getTranslatedString() {
            return new TranslationTextComponent("assortedtools.wand.mode." + this.name);
        }

        static {
            values = Lists.newArrayList((Object[])BreakingMode.values()).stream().sorted(Comparator.comparingInt(BreakingMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(BreakingMode::getOrder)).collect(Collectors.toList());
        }
    }
}

