/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.item.WandItem;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import com.grim3212.assorted.tools.common.util.WandCoord3D;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WandBuildingItem
extends WandItem {
    public WandBuildingItem(boolean reinforced, Item.Properties props) {
        super(reinforced, props);
    }

    @Override
    protected boolean canBreak(World worldIn, BlockPos pos, ItemStack stack) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_185904_a().func_76222_j() || state.func_185904_a().func_186274_m() == PushReaction.DESTROY || state.func_185904_a().func_76224_d()) {
            return true;
        }
        switch (BuildingMode.fromString(NBTHelper.getString(stack, "Mode"))) {
            case BUILD_BOX: 
            case BUILD_ROOM: 
            case BUILD_FRAME: 
            case BUILD_CAVES: {
                return state.func_177230_c() instanceof FlowingFluidBlock;
            }
            case BUILD_WATER: 
            case BUILD_LAVA: {
                return state.func_177230_c() == Blocks.field_150478_aa || state.func_177230_c() instanceof FlowingFluidBlock;
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2D, ItemStack stack) {
        switch (BuildingMode.fromString(NBTHelper.getString(stack, "Mode"))) {
            case BUILD_BOX: 
            case BUILD_ROOM: 
            case BUILD_FRAME: 
            case BUILD_WATER: 
            case BUILD_LAVA: 
            case BUILD_TORCHES: {
                return range - 400 > maxDiff;
            }
            case BUILD_CAVES: {
                return range2D - 1600 > maxDiff;
            }
        }
        return true;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{1.0, 0.8, 0.0};
    }

    @Override
    protected boolean isIncompatible(BlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_196603_bb || state.func_177230_c() == Blocks.field_150332_K || state.func_177230_c() instanceof BedBlock || state.func_177230_c() instanceof DoorBlock || state.func_177230_c() instanceof AbstractSignBlock;
    }

    private boolean canPlace(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand) {
        if (this.canBreak(world, pos, player.func_184586_b(hand))) {
            if (player.field_71075_bZ.field_75099_e) {
                return true;
            }
            if (state.func_177230_c() == Blocks.field_150434_aF || state.func_177230_c() == Blocks.field_196608_cF || state.func_177230_c() == Blocks.field_150488_af || state.func_177230_c() instanceof PressurePlateBlock || state.func_177230_c() == Blocks.field_150433_aE) {
                return false;
            }
            return !(state.func_177230_c() instanceof TorchBlock) && !(state.func_177230_c() instanceof FlowerBlock);
        }
        return false;
    }

    protected boolean consumeItems(ItemStack neededStack, PlayerEntity entityplayer, int neededItems, WandCoord3D end) {
        ItemStack currentItem;
        int t;
        if (((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue() || entityplayer.func_184812_l_()) {
            return true;
        }
        int invItems = 0;
        for (t = 0; t < entityplayer.field_71071_by.func_70302_i_() && ((currentItem = entityplayer.field_71071_by.func_70301_a(t)).func_190926_b() || !currentItem.func_77969_a(neededStack) || (invItems += currentItem.func_190916_E()) != neededItems); ++t) {
        }
        if (neededItems > invItems) {
            this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("error.wand.toofewitems", new Object[]{neededItems, invItems}));
            return false;
        }
        for (t = entityplayer.field_71071_by.func_70302_i_() - 1; t >= 0; --t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem.func_190926_b() || !currentItem.func_77969_a(neededStack)) continue;
            int stackSize = currentItem.func_190916_E();
            if (stackSize < neededItems) {
                entityplayer.field_71071_by.func_70299_a(t, ItemStack.field_190927_a);
                neededItems -= stackSize;
                continue;
            }
            if (stackSize < neededItems) continue;
            entityplayer.field_71071_by.func_70298_a(t, neededItems);
            neededItems = 0;
            break;
        }
        return true;
    }

    private boolean emptyBuckets(PlayerEntity entityplayer, int neededItems, boolean lava) {
        ItemStack currentItem;
        int t;
        Item vanillaBucket;
        Item item = vanillaBucket = lava ? Items.field_151129_at : Items.field_151131_as;
        if (((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue() || entityplayer.func_184812_l_()) {
            return true;
        }
        int itemsInInventory = 0;
        for (t = 0; t < entityplayer.field_71071_by.func_70302_i_(); ++t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem.func_190926_b() || currentItem.func_77973_b() != vanillaBucket) continue;
            ++itemsInInventory;
        }
        if (itemsInInventory < neededItems) {
            return false;
        }
        for (t = entityplayer.field_71071_by.func_70302_i_() - 1; t >= 0; --t) {
            currentItem = entityplayer.field_71071_by.func_70301_a(t);
            if (currentItem.func_190926_b() || currentItem.func_77973_b() != vanillaBucket) continue;
            entityplayer.field_71071_by.func_70299_a(t, ItemStack.field_190927_a);
            entityplayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151133_ar));
            if (--neededItems != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEffect(World world, PlayerEntity entityplayer, Hand hand, WandCoord3D start, WandCoord3D end, BlockState state) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString(entityplayer.func_184586_b(hand), "Mode"));
        if (state != this.stateClicked && (mode == BuildingMode.BUILD_BOX || mode == BuildingMode.BUILD_ROOM || mode == BuildingMode.BUILD_FRAME || mode == BuildingMode.BUILD_TORCHES)) {
            this.error(entityplayer, end, "notsamecorner");
            return false;
        }
        boolean flag = this.doBuilding(world, start, end, mode, entityplayer, hand, state);
        if (flag && mode != BuildingMode.BUILD_WATER && mode != BuildingMode.BUILD_LAVA) {
            world.func_184133_a((PlayerEntity)null, end.pos, SoundEvents.field_187737_v, SoundCategory.BLOCKS, (world.field_73012_v.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        }
        if (flag && mode == BuildingMode.BUILD_WATER) {
            world.func_184133_a((PlayerEntity)null, end.pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, (world.field_73012_v.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        }
        if (flag && mode == BuildingMode.BUILD_WATER) {
            world.func_184133_a((PlayerEntity)null, end.pos, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, (world.field_73012_v.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
        }
        return flag;
    }

    private boolean doBuilding(World world, WandCoord3D start, WandCoord3D end, BuildingMode mode, PlayerEntity entityplayer, Hand hand, BlockState state) {
        int X = 0;
        int Y = 0;
        int Z = 0;
        BlockState stateAt = Blocks.field_150350_a.func_176223_P();
        ItemStack neededStack = this.getNeededItem(world, state, entityplayer);
        int multiplier = this.getNeededCount(state);
        int neededItems = 0;
        int affected = 0;
        switch (mode) {
            case BUILD_BOX: {
                neededItems = 0;
                for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                    for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                        for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                            if (!this.canPlace(world, new BlockPos(X, Y, Z), state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                BlockPos newPos = new BlockPos(X, Y, Z);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.func_180501_a(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.func_177230_c() == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.func_177956_o();
                            }
                            if (run == 1) {
                                Y = end.pos.func_177956_o();
                            }
                            for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                                for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                                    BlockPos newPos = new BlockPos(X, Y, Z);
                                    if (world.func_180495_p(newPos).func_177230_c() != Blocks.field_150346_d || world.func_180495_p(newPos.func_177984_a()).func_177230_c() != null && world.func_180495_p(newPos.func_177984_a()).func_200015_d((IBlockReader)world, newPos.func_177984_a())) continue;
                                    world.func_175656_a(newPos, Blocks.field_150349_c.func_176223_P());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_ROOM: {
                neededItems = 0;
                for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                    for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                        for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                            if (X != start.pos.func_177958_n() && Y != start.pos.func_177956_o() && Z != start.pos.func_177952_p() && X != end.pos.func_177958_n() && Y != end.pos.func_177956_o() && Z != end.pos.func_177952_p() || !this.canPlace(world, new BlockPos(X, Y, Z), state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                BlockPos newPos = new BlockPos(X, Y, Z);
                                if (X != start.pos.func_177958_n() && Y != start.pos.func_177956_o() && Z != start.pos.func_177952_p() && X != end.pos.func_177958_n() && Y != end.pos.func_177956_o() && Z != end.pos.func_177952_p() || !this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.func_180501_a(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.func_177230_c() == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.func_177956_o();
                            }
                            if (run == 1) {
                                Y = end.pos.func_177956_o();
                            }
                            for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                                for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                                    BlockPos newPos = new BlockPos(X, Y, Z);
                                    if (world.func_180495_p(newPos).func_177230_c() != Blocks.field_150346_d || world.func_180495_p(newPos.func_177984_a()).func_177230_c() != null && world.func_180495_p(newPos.func_177984_a()).func_200015_d((IBlockReader)world, newPos.func_177984_a())) continue;
                                    world.func_175656_a(newPos, Blocks.field_150349_c.func_176223_P());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_FRAME: {
                neededItems = 0;
                for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                    for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                        for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                            if (!(X == start.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == start.pos.func_177958_n() || X == start.pos.func_177958_n() && Y == end.pos.func_177956_o() || X == end.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == end.pos.func_177952_p() || Y == end.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == end.pos.func_177958_n() || Z == end.pos.func_177952_p() && X == start.pos.func_177958_n() || X == end.pos.func_177958_n() && Y == end.pos.func_177956_o() || Y == end.pos.func_177956_o() && Z == end.pos.func_177952_p()) && (Z != end.pos.func_177952_p() || X != end.pos.func_177958_n() || !this.canPlace(world, new BlockPos(X, Y, Z), state, entityplayer, hand))) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                if (!(X == start.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == start.pos.func_177958_n() || X == start.pos.func_177958_n() && Y == end.pos.func_177956_o() || X == end.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == end.pos.func_177952_p() || Y == end.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == end.pos.func_177958_n() || Z == end.pos.func_177952_p() && X == start.pos.func_177958_n() || X == end.pos.func_177958_n() && Y == end.pos.func_177956_o() || Y == end.pos.func_177956_o() && Z == end.pos.func_177952_p()) && (Z != end.pos.func_177952_p() || X != end.pos.func_177958_n())) continue;
                                BlockPos newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.func_180501_a(newPos, state, 3);
                                if (this.rand.nextInt(neededItems / 50 + 1) == 0) {
                                    this.particles(world, newPos, 0);
                                }
                                ++affected;
                            }
                        }
                    }
                    if (this.stateOrig.func_177230_c() == Blocks.field_150349_c && affected > 0) {
                        for (int run = 0; run <= 1; ++run) {
                            if (run == 0) {
                                Y = start.pos.func_177956_o();
                            }
                            if (run == 1) {
                                Y = end.pos.func_177956_o();
                            }
                            for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                                for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                                    BlockPos newPos = new BlockPos(X, Y, Z);
                                    if (!(X == start.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == start.pos.func_177958_n() || X == start.pos.func_177958_n() && Y == end.pos.func_177956_o() || X == end.pos.func_177958_n() && Y == start.pos.func_177956_o() || Y == start.pos.func_177956_o() && Z == end.pos.func_177952_p() || Y == end.pos.func_177956_o() && Z == start.pos.func_177952_p() || Z == start.pos.func_177952_p() && X == end.pos.func_177958_n() || Z == end.pos.func_177952_p() && X == start.pos.func_177958_n() || X == end.pos.func_177958_n() && Y == end.pos.func_177956_o() || Y == end.pos.func_177956_o() && Z == end.pos.func_177952_p()) && (Z != end.pos.func_177952_p() || X != end.pos.func_177958_n() || world.func_180495_p(newPos).func_177230_c() != Blocks.field_150346_d || world.func_180495_p(newPos.func_177984_a()).func_177230_c() != null && world.func_180495_p(newPos.func_177984_a()).func_200015_d((IBlockReader)world, newPos.func_177984_a()))) continue;
                                    world.func_175656_a(newPos, Blocks.field_150349_c.func_176223_P());
                                }
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_TORCHES: {
                BlockPos newPos;
                neededItems = 0;
                for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); X += 5) {
                    for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); Z += 5) {
                        for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                            newPos = new BlockPos(X, Y, Z);
                            stateAt = world.func_180495_p(newPos);
                            if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                            neededItems += multiplier;
                        }
                    }
                }
                if (neededItems == 0) {
                    if (!world.field_72995_K) {
                        this.error(entityplayer, end, "nowork");
                    }
                    return false;
                }
                if (this.consumeItems(neededStack, entityplayer, neededItems, end)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); X += 5) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); Z += 5) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canPlace(world, newPos, state, entityplayer, hand)) continue;
                                world.func_180501_a(newPos, state, 3);
                                this.particles(world, newPos, 0);
                                ++affected;
                            }
                        }
                    }
                    return affected > 0;
                }
                return false;
            }
            case BUILD_WATER: {
                BlockPos newPos;
                if (!this.reinforced && !((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
                    this.error(entityplayer, end, "cantfillwater");
                    return false;
                }
                if (!((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
                    neededItems = 0;
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_72995_K) {
                            this.error(entityplayer, end, "nowork");
                        }
                        return false;
                    }
                }
                if (this.emptyBuckets(entityplayer, 2, false)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                                world.func_175656_a(newPos, Blocks.field_150355_j.func_176223_P());
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (stateAt.func_177230_c() != Blocks.field_150355_j) continue;
                                world.func_195593_d(newPos, Blocks.field_150355_j);
                                if (world.func_180495_p(newPos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                                this.particles(world, newPos, 2);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, end, "toofewwater");
                return false;
            }
            case BUILD_LAVA: {
                BlockPos newPos;
                if (!this.reinforced && !((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
                    this.error(entityplayer, end, "cantfilllava");
                    return false;
                }
                neededItems = 0;
                if (!((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                                ++neededItems;
                            }
                        }
                    }
                    if (neededItems == 0) {
                        if (!world.field_72995_K) {
                            this.error(entityplayer, end, "nowork");
                        }
                        return false;
                    }
                }
                if (this.emptyBuckets(entityplayer, neededItems, true)) {
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (!this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                                world.func_175656_a(newPos, Blocks.field_150353_l.func_176223_P());
                                ++affected;
                            }
                        }
                    }
                    if (affected == 0) {
                        return false;
                    }
                    for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                        for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                            for (Y = start.pos.func_177956_o(); Y <= end.pos.func_177956_o(); ++Y) {
                                newPos = new BlockPos(X, Y, Z);
                                stateAt = world.func_180495_p(newPos);
                                if (stateAt.func_177230_c() != Blocks.field_150353_l) continue;
                                world.func_195593_d(newPos, Blocks.field_150353_l);
                            }
                        }
                    }
                    return true;
                }
                this.error(entityplayer, end, "toofewlava");
                return false;
            }
            case BUILD_CAVES: {
                if (!this.reinforced && !((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
                    this.error(entityplayer, end, "cantfillcave");
                    return false;
                }
                boolean underground = false;
                long cnt = 0L;
                for (X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                    for (Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                        underground = false;
                        for (Y = 127; Y > 1; --Y) {
                            BlockPos newPos = new BlockPos(X, Y, Z);
                            stateAt = world.func_180495_p(newPos);
                            boolean surfaceBlock = this.isSurface(stateAt);
                            if (!underground && surfaceBlock) {
                                underground = true;
                                continue;
                            }
                            if (!underground || !this.canBreak(world, newPos, entityplayer.func_184586_b(hand))) continue;
                            world.func_175656_a(newPos, Blocks.field_150348_b.func_176223_P());
                            ++cnt;
                        }
                    }
                }
                if (cnt > 0L) {
                    if (!world.field_72995_K) {
                        this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("result.wand.fill", new Object[]{cnt}));
                    }
                    return true;
                }
                if (!world.field_72995_K) {
                    this.error(entityplayer, end, "nocave");
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public ItemStack cycleMode(PlayerEntity player, ItemStack stack) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString(stack, "Mode"));
        BuildingMode next = BuildingMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString(stack, "Mode", next.func_176610_l());
        this.sendMessage(player, (ITextComponent)new TranslationTextComponent("assortedtools.wand.switched", new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BuildingMode mode = BuildingMode.fromString(NBTHelper.getString(stack, "Mode"));
        if (mode != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.wand.current", new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.wand.broken"));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.putString(stack, "Mode", BuildingMode.BUILD_BOX.func_176610_l());
            items.add((Object)stack);
        }
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        NBTHelper.putString(stack, "Mode", BuildingMode.BUILD_BOX.func_176610_l());
    }

    private static enum BuildingMode implements IStringSerializable
    {
        BUILD_BOX("buildbox", 0),
        BUILD_ROOM("buildroom", 1),
        BUILD_FRAME("buildframe", 2),
        BUILD_TORCHES("buildtorches", 3),
        BUILD_WATER("buildwater", 4, true),
        BUILD_LAVA("buildlava", 5, true),
        BUILD_CAVES("buildcaves", 6, true);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<BuildingMode> values;
        private static final List<BuildingMode> notReinforced;

        private BuildingMode(String name, int order) {
            this(name, order, false);
        }

        private BuildingMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static BuildingMode getNext(BuildingMode current, ItemStack stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static BuildingMode fromString(String type) {
            for (BuildingMode mode : values) {
                if (!mode.func_176610_l().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String func_176610_l() {
            return this.name;
        }

        public TranslationTextComponent getTranslatedString() {
            return new TranslationTextComponent("assortedtools.wand.mode." + this.name);
        }

        static {
            values = Lists.newArrayList((Object[])BuildingMode.values()).stream().sorted(Comparator.comparingInt(BuildingMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(BuildingMode::getOrder)).collect(Collectors.toList());
        }
    }
}

