/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.grim3212.assorted.tools.AssortedTools;
import com.grim3212.assorted.tools.api.item.ISwitchModes;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import com.grim3212.assorted.tools.common.util.WandCoord3D;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class WandItem
extends Item
implements ISwitchModes {
    protected final boolean reinforced;
    protected Random rand;
    protected BlockState stateOrig = Blocks.field_150350_a.func_176223_P();
    protected BlockState stateClicked = Blocks.field_150350_a.func_176223_P();

    public WandItem(boolean reinforced, Item.Properties properties) {
        super(properties.func_200916_a(AssortedTools.ASSORTED_TOOLS_ITEM_GROUP));
        this.reinforced = reinforced;
        this.rand = new Random();
    }

    protected boolean func_194125_a(ItemGroup group) {
        return (Boolean)ToolsConfig.COMMON.wandsEnabled.get() != false ? super.func_194125_a(group) : false;
    }

    public abstract void func_77622_d(ItemStack var1, World var2, PlayerEntity var3);

    protected abstract boolean canBreak(World var1, BlockPos var2, ItemStack var3);

    public ItemStack getNeededItem(World world, BlockState state, PlayerEntity player) {
        return state.func_177230_c().getPickBlock(state, null, (IBlockReader)world, BlockPos.field_177992_a, player);
    }

    public int getNeededCount(BlockState state) {
        if (state.func_177230_c() instanceof SlabBlock) {
            return 2;
        }
        return 1;
    }

    public boolean isSurface(BlockState state) {
        return state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150351_n || state.func_177230_c() == Blocks.field_150322_A || state.func_177230_c() == Blocks.field_150354_m || state.func_177230_c() == Blocks.field_150357_h || state.func_177230_c() == Blocks.field_150365_q || state.func_177230_c() == Blocks.field_150366_p || state.func_177230_c() == Blocks.field_150352_o || state.func_177230_c() == Blocks.field_150482_ag || state.func_177230_c() == Blocks.field_150369_x;
    }

    protected abstract boolean isTooFar(int var1, int var2, int var3, ItemStack var4);

    public boolean isTooFar(WandCoord3D a, WandCoord3D b, ItemStack stack) {
        if (((Boolean)ToolsConfig.COMMON.freeBuildMode.get()).booleanValue()) {
            return a.getDistance(b) > 1500.0;
        }
        return this.isTooFar((int)a.getDistance(b), 10, (int)a.getDistanceFlat(b), stack);
    }

    protected abstract boolean doEffect(World var1, PlayerEntity var2, Hand var3, WandCoord3D var4, WandCoord3D var5, BlockState var6);

    protected void sendMessage(PlayerEntity player, ITextComponent message) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a(message, player.func_110124_au());
        }
    }

    protected void error(PlayerEntity entityplayer, WandCoord3D p, String reason) {
        entityplayer.field_70170_p.func_184133_a(entityplayer, p.pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, (entityplayer.field_70170_p.field_73012_v.nextFloat() + 0.7f) / 2.0f, 0.5f + entityplayer.field_70170_p.field_73012_v.nextFloat() * 0.3f);
        this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("error.wand." + reason));
        this.particles(entityplayer.field_70170_p, p.pos, 3);
    }

    protected abstract double[] getParticleColor();

    private void particles(World world, WandCoord3D c, int effect) {
        this.particles(world, c.pos, effect);
    }

    protected void particles(World world, BlockPos pos, int effect) {
        double d = 0.0625;
        if (effect == 1) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        if (effect == 2) {
            world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            return;
        }
        double R = 0.0;
        double G = 0.0;
        double B = 0.0;
        if (effect == 0) {
            double[] color = this.getParticleColor();
            R = color[0];
            G = color[1];
            B = color[2];
        } else {
            R = 0.8;
        }
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)pos.func_177958_n() + this.rand.nextFloat();
            double d2 = (float)pos.func_177956_o() + this.rand.nextFloat();
            double d3 = (float)pos.func_177952_p() + this.rand.nextFloat();
            if (l == 0 && !world.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)world, pos)) {
                d2 = (double)(pos.func_177956_o() + 1) + d;
            }
            if (l == 1 && !world.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)world, pos)) {
                d2 = (double)(pos.func_177956_o() + 0) - d;
            }
            if (l == 2 && !world.func_180495_p(pos.func_177968_d()).func_200015_d((IBlockReader)world, pos)) {
                d3 = (double)(pos.func_177952_p() + 1) + d;
            }
            if (l == 3 && !world.func_180495_p(pos.func_177978_c()).func_200015_d((IBlockReader)world, pos)) {
                d3 = (double)(pos.func_177952_p() + 0) - d;
            }
            if (l == 4 && !world.func_180495_p(pos.func_177974_f()).func_200015_d((IBlockReader)world, pos)) {
                d1 = (double)(pos.func_177958_n() + 1) + d;
            }
            if (l == 5 && !world.func_180495_p(pos.func_177976_e()).func_200015_d((IBlockReader)world, pos)) {
                d1 = (double)(pos.func_177958_n() + 0) - d;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d1, d2, d3, R, G, B);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World worldIn = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        boolean isFree = (Boolean)ToolsConfig.COMMON.freeBuildMode.get() != false || playerIn.func_184812_l_();
        this.stateOrig = worldIn.func_180495_p(pos);
        BlockState state = this.stateOrig;
        if (state.func_177230_c() == Blocks.field_150349_c) {
            state = Blocks.field_150346_d.func_176223_P();
        }
        WandCoord3D clicked_current = new WandCoord3D(pos, state);
        if (this.isIncompatible(state)) {
            this.error(playerIn, clicked_current, "cantbuild");
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        WandCoord3D start = WandCoord3D.getFromNBT(stack.func_77978_p(), "Start");
        if (start == null) {
            worldIn.func_184133_a((PlayerEntity)null, pos, state.func_177230_c().getSoundType(state, (IWorldReader)worldIn, pos, null).func_185845_c(), SoundCategory.BLOCKS, (state.func_177230_c().getSoundType(state, (IWorldReader)worldIn, pos, null).func_185843_a() + 1.0f) / 2.0f, state.func_177230_c().getSoundType(state, (IWorldReader)worldIn, pos, null).func_185847_b() * 0.8f);
            this.stateClicked = state;
            clicked_current.writeToNBT(stack.func_77978_p(), "Start");
            this.particles(worldIn, clicked_current, 0);
            NBTHelper.putBoolean(stack, "firstUse", false);
            return ActionResultType.SUCCESS;
        }
        if (NBTHelper.getBoolean(stack, "firstUse")) {
            NBTHelper.removeTag(stack, "Start");
            this.error(playerIn, clicked_current, "nostart");
            return ActionResultType.SUCCESS;
        }
        WandCoord3D.findEnds(start, clicked_current);
        if (this.isTooFar(start, clicked_current, stack)) {
            NBTHelper.removeTag(stack, "Start");
            this.error(playerIn, clicked_current, "toofar");
            return ActionResultType.SUCCESS;
        }
        boolean damage = this.doEffect(worldIn, playerIn, hand, start, clicked_current, state);
        if (damage) {
            NBTHelper.putBoolean(stack, "firstUse", true);
            if (!isFree) {
                NBTHelper.removeTag(stack, "Start");
                stack.func_222118_a(1, (LivingEntity)playerIn, s -> s.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
        }
        NBTHelper.removeTag(stack, "Start");
        return ActionResultType.SUCCESS;
    }

    protected boolean isIncompatible(BlockState state) {
        return false;
    }
}

