/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item;

import com.google.common.collect.Lists;
import com.grim3212.assorted.tools.common.handler.ToolsConfig;
import com.grim3212.assorted.tools.common.item.WandItem;
import com.grim3212.assorted.tools.common.util.NBTHelper;
import com.grim3212.assorted.tools.common.util.WandCoord3D;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WandMiningItem
extends WandItem {
    public WandMiningItem(boolean reinforced, Item.Properties props) {
        super(reinforced, props);
    }

    private static boolean isMiningOre(BlockState state) {
        return ToolsConfig.COMMON.miningSurfaceBlocks.getLoadedStates().contains((Object)state);
    }

    @Override
    protected boolean canBreak(World worldIn, BlockPos pos, ItemStack stack) {
        BlockState state = worldIn.func_180495_p(pos);
        switch (MiningMode.fromString(NBTHelper.getString(stack, "Mode"))) {
            case MINE_ALL: {
                return !(state.func_177230_c() == Blocks.field_150357_h && (Boolean)ToolsConfig.COMMON.bedrockBreaking.get() == false || state.func_177230_c() == Blocks.field_150343_Z && (Boolean)ToolsConfig.COMMON.easyMiningObsidian.get() == false);
            }
            case MINE_DIRT: {
                return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150354_m || state.func_177230_c() == Blocks.field_150351_n || state.func_177230_c() instanceof LeavesBlock || state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == Blocks.field_150433_aE || state.func_177230_c() == Blocks.field_150425_aM || state.func_177230_c() == Blocks.field_150395_bd || state.func_177230_c() instanceof FlowerBlock;
            }
            case MINE_WOOD: {
                return state.func_185904_a() == Material.field_151575_d;
            }
            case MINE_ORES: {
                return !(!WandMiningItem.isMiningOre(state) || state.func_177230_c() == Blocks.field_150357_h && (Boolean)ToolsConfig.COMMON.bedrockBreaking.get() == false || state.func_177230_c() == Blocks.field_150343_Z && (Boolean)ToolsConfig.COMMON.easyMiningObsidian.get() == false);
            }
        }
        return false;
    }

    @Override
    protected boolean isTooFar(int range, int maxDiff, int range2D, ItemStack stack) {
        switch (MiningMode.fromString(NBTHelper.getString(stack, "Mode"))) {
            case MINE_ALL: 
            case MINE_DIRT: {
                return range - 250 > maxDiff;
            }
            case MINE_WOOD: {
                return range2D - 400 > maxDiff;
            }
            case MINE_ORES: {
                return range2D - 60 > maxDiff;
            }
        }
        return true;
    }

    @Override
    protected double[] getParticleColor() {
        return new double[]{0.01, 0.8, 1.0};
    }

    @Override
    protected boolean doEffect(World world, PlayerEntity entityplayer, Hand hand, WandCoord3D start, WandCoord3D end, BlockState state) {
        boolean damage = this.doMining(world, start, end, entityplayer, hand);
        if (damage) {
            world.func_184133_a((PlayerEntity)null, end.pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 2.5f, 0.5f + world.field_73012_v.nextFloat() * 0.3f);
        }
        return damage;
    }

    private boolean doMining(World world, WandCoord3D start, WandCoord3D end, PlayerEntity entityplayer, Hand hand) {
        BlockState stateAt;
        int max;
        BlockState state;
        ItemStack stack = entityplayer.func_184586_b(hand);
        MiningMode mode = MiningMode.fromString(NBTHelper.getString(stack, "Mode"));
        BlockPos startPos = start.pos;
        BlockPos endPos = end.pos;
        if (mode == MiningMode.MINE_ALL && startPos.equals((Object)endPos) && !((Boolean)ToolsConfig.COMMON.easyMiningObsidian.get()).booleanValue() && (state = world.func_180495_p(startPos)).func_177230_c() == Blocks.field_150343_Z) {
            state.func_177230_c().func_176208_a(world, startPos, state, entityplayer);
            state.func_177230_c().func_180657_a(world, entityplayer, startPos, state, world.func_175625_s(startPos), entityplayer.func_184607_cu());
            this.particles(world, startPos, 1);
            return true;
        }
        int blocks2Dig = 0;
        boolean isFree = (Boolean)ToolsConfig.COMMON.bedrockBreaking.get() != false || entityplayer.func_184812_l_();
        int n = max = this.reinforced || isFree ? 1024 : 512;
        if (mode == MiningMode.MINE_ORES) {
            BlockState stateAt2;
            if (!this.reinforced) {
                this.error(entityplayer, end, "cantminesurface");
                return false;
            }
            List iterable = BlockPos.func_218281_b((BlockPos)new BlockPos(start.pos.func_177958_n(), 1, start.pos.func_177952_p()), (BlockPos)new BlockPos(end.pos.func_177958_n(), end.pos.func_177956_o() + 1, end.pos.func_177952_p())).map(BlockPos::func_185334_h).collect(Collectors.toList());
            for (BlockPos pos : iterable) {
                stateAt2 = world.func_180495_p(pos);
                if (!WandMiningItem.isMiningOre(stateAt2)) continue;
                if (stateAt2.func_177230_c() == Blocks.field_150450_ax || stateAt2.func_177230_c() == Blocks.field_150369_x) {
                    blocks2Dig += 4;
                    continue;
                }
                ++blocks2Dig;
            }
            if (blocks2Dig - max > 10) {
                this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("error.wand.toomany", new Object[]{blocks2Dig, max}));
                return true;
            }
            int surface = 127;
            long cnt = 0L;
            for (int X = start.pos.func_177958_n(); X <= end.pos.func_177958_n(); ++X) {
                for (int Z = start.pos.func_177952_p(); Z <= end.pos.func_177952_p(); ++Z) {
                    boolean underground = false;
                    for (int Y = 127; Y > 1; --Y) {
                        BlockPos pos = new BlockPos(X, Y, Z);
                        stateAt2 = world.func_180495_p(pos);
                        if (!underground && world.func_175623_d(pos)) {
                            surface = Y;
                        }
                        boolean surfaceBlock = this.isSurface(stateAt2);
                        if (!underground && surfaceBlock) {
                            underground = true;
                        }
                        if (!WandMiningItem.isMiningOre(stateAt2)) continue;
                        TileEntity tile = world.func_175625_s(pos);
                        if (!world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P())) continue;
                        pos = new BlockPos(X, surface, Z);
                        stateAt2.func_177230_c().func_176208_a(world, pos, stateAt2, entityplayer);
                        stateAt2.func_177230_c().func_180657_a(world, entityplayer, pos, stateAt2, tile, entityplayer.func_184607_cu());
                        ++cnt;
                    }
                }
            }
            if (cnt == 0L) {
                if (!world.field_72995_K) {
                    this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("result.wand.mine"));
                }
                return false;
            }
            return true;
        }
        List iterable = BlockPos.func_218281_b((BlockPos)startPos, (BlockPos)endPos).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos : iterable) {
            stateAt = world.func_180495_p(pos);
            if (!this.canBreak(world, pos, stack)) continue;
            if (stateAt.func_177230_c() == Blocks.field_150450_ax || stateAt.func_177230_c() == Blocks.field_150369_x) {
                blocks2Dig += 4;
                continue;
            }
            ++blocks2Dig;
        }
        if (blocks2Dig >= max) {
            this.sendMessage(entityplayer, (ITextComponent)new TranslationTextComponent("error.wand.toomany", new Object[]{blocks2Dig, this.reinforced || isFree ? 1024 : 512}));
            return false;
        }
        if (blocks2Dig == 0) {
            if (!world.field_72995_K) {
                this.error(entityplayer, end, "nowork");
            }
            return false;
        }
        iterable = BlockPos.func_218281_b((BlockPos)startPos, (BlockPos)endPos).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (Object object : iterable) {
            BlockPos newPos = (BlockPos)object;
            stateAt = world.func_180495_p(newPos);
            if (!this.canBreak(world, newPos, stack)) continue;
            TileEntity tile = world.func_175625_s(newPos);
            if (!stateAt.func_177230_c().removedByPlayer(stateAt, world, newPos, entityplayer, true, world.func_204610_c(newPos))) continue;
            stateAt.func_177230_c().func_176208_a(world, newPos, stateAt, entityplayer);
            stateAt.func_177230_c().func_180657_a(world, entityplayer, newPos, stateAt, tile, entityplayer.func_184607_cu());
            if (this.rand.nextInt(blocks2Dig / 50 + 1) != 0) continue;
            this.particles(world, newPos, 1);
        }
        return true;
    }

    @Override
    public ItemStack cycleMode(PlayerEntity player, ItemStack stack) {
        MiningMode mode = MiningMode.fromString(NBTHelper.getString(stack, "Mode"));
        MiningMode next = MiningMode.getNext(mode, stack, this.reinforced);
        NBTHelper.putString(stack, "Mode", next.func_176610_l());
        this.sendMessage(player, (ITextComponent)new TranslationTextComponent("assortedtools.wand.switched", new Object[]{next.getTranslatedString()}));
        return stack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.putString(stack, "Mode", MiningMode.MINE_ALL.func_176610_l());
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        MiningMode mode = MiningMode.fromString(NBTHelper.getString(stack, "Mode"));
        if (mode != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.wand.current", new Object[]{mode.getTranslatedString()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("assortedtools.broken"));
        }
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        NBTHelper.putString(stack, "Mode", MiningMode.MINE_ALL.func_176610_l());
    }

    private static enum MiningMode implements IStringSerializable
    {
        MINE_ALL("mineall", 0),
        MINE_DIRT("minedirt", 1),
        MINE_WOOD("minewood", 2),
        MINE_ORES("mineores", 3, true);

        private final String name;
        private final int order;
        private final boolean reinforcedOnly;
        private static final List<MiningMode> values;
        private static final List<MiningMode> notReinforced;

        private MiningMode(String name, int order) {
            this(name, order, false);
        }

        private MiningMode(String name, int order, boolean reinforcedOnly) {
            this.name = name;
            this.order = order;
            this.reinforcedOnly = reinforcedOnly;
        }

        private static MiningMode getNext(MiningMode current, ItemStack stack, boolean reinforced) {
            if (reinforced) {
                int i = values.indexOf((Object)current) + 1;
                if (i >= values.size()) {
                    i = 0;
                }
                return values.get(i);
            }
            int i = notReinforced.indexOf((Object)current) + 1;
            if (i >= notReinforced.size()) {
                i = 0;
            }
            return notReinforced.get(i);
        }

        private static MiningMode fromString(String type) {
            for (MiningMode mode : values) {
                if (!mode.func_176610_l().equalsIgnoreCase(type)) continue;
                return mode;
            }
            return null;
        }

        private int getOrder() {
            return this.order;
        }

        public String func_176610_l() {
            return this.name;
        }

        public TranslationTextComponent getTranslatedString() {
            return new TranslationTextComponent("assortedtools.wand.mode." + this.name);
        }

        static {
            values = Lists.newArrayList((Object[])MiningMode.values()).stream().sorted(Comparator.comparingInt(MiningMode::getOrder)).collect(Collectors.toList());
            notReinforced = values.stream().filter(mode -> !mode.reinforcedOnly).sorted(Comparator.comparingInt(MiningMode::getOrder)).collect(Collectors.toList());
        }
    }
}

