/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item.configurable;

import com.google.common.collect.Sets;
import com.grim3212.assorted.tools.common.handler.ModdedItemTierHolder;
import com.grim3212.assorted.tools.common.item.configurable.ConfigurableToolItem;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ConfigurableAxeItem
extends ConfigurableToolItem {
    private static final Set<Material> EFFECTIVE_ON_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    private static final Set<Block> EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_});

    public ConfigurableAxeItem(ModdedItemTierHolder tierHolder, Item.Properties builder) {
        super(tierHolder, tierHolder.getAxeDamage(), tierHolder.getAxeSpeed(), EFFECTIVE_ON_BLOCKS, builder.addToolType(ToolType.AXE, tierHolder.getHarvestLevel()));
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return EFFECTIVE_ON_MATERIALS.contains(material) ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        BlockState block = blockstate.getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.AXE);
        if (block != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public void addToolTypes(Map<ToolType, Integer> toolClasses, ItemStack stack) {
        toolClasses.put(ToolType.AXE, this.getTierHarvestLevel());
    }
}

