/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item.configurable;

import com.google.common.collect.ImmutableSet;
import com.grim3212.assorted.tools.common.handler.ItemTierHolder;
import com.grim3212.assorted.tools.common.item.configurable.ConfigurableToolItem;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public class ConfigurableHoeItem
extends ConfigurableToolItem {
    private static final Set<Block> EFFECTIVE_ON_BLOCKS = ImmutableSet.of((Object)Blocks.field_189878_dg, (Object)Blocks.field_235374_mn_, (Object)Blocks.field_150407_cf, (Object)Blocks.field_203216_jz, (Object)Blocks.field_235396_nb_, (Object)Blocks.field_235383_mw_, (Object[])new Block[]{Blocks.field_150360_v, Blocks.field_196577_ad, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X, Blocks.field_196574_ab, Blocks.field_196572_aa, Blocks.field_196647_Y});

    public ConfigurableHoeItem(ItemTierHolder tierHolder, Item.Properties properties) {
        super(tierHolder, -tierHolder.getHarvestLevel(), 0.0f, EFFECTIVE_ON_BLOCKS, properties.addToolType(ToolType.HOE, tierHolder.getHarvestLevel()));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = world.func_180495_p(blockpos).getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.HOE)) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public void addToolTypes(Map<ToolType, Integer> toolClasses, ItemStack stack) {
        toolClasses.put(ToolType.HOE, this.getTierHarvestLevel());
    }
}

