/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.item.configurable;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.grim3212.assorted.tools.common.handler.ItemTierHolder;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraftforge.common.ToolType;

public abstract class ConfigurableToolItem
extends ToolItem {
    private final ItemTierHolder tierHolder;
    private final float toolDamage;
    private final Map<ToolType, Integer> toolClasses = Maps.newHashMap();

    public ConfigurableToolItem(ItemTierHolder tierHolder, float attackDamageIn, float attackSpeedIn, Set<Block> effectiveBlocksIn, Item.Properties builderIn) {
        super(attackDamageIn, attackSpeedIn, tierHolder.getDefaultTier(), effectiveBlocksIn, builderIn);
        this.tierHolder = tierHolder;
        this.toolDamage = attackDamageIn;
        this.field_77865_bY = attackDamageIn + tierHolder.getDamage();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.field_234674_d_ = builder.build();
    }

    public ItemTierHolder getTierHolder() {
        return this.tierHolder;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.tierHolder.getMaxUses();
    }

    public float func_234675_d_() {
        return this.toolDamage + this.tierHolder.getDamage();
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.tierHolder.getEnchantability();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (this.getToolTypes(stack).stream().anyMatch(e -> state.isToolEffective(e))) {
            return this.tierHolder.getEfficiency();
        }
        return this.field_150914_c.contains(state.func_177230_c()) ? this.tierHolder.getEfficiency() : 1.0f;
    }

    public int getTierHarvestLevel() {
        return this.tierHolder.getHarvestLevel();
    }

    public abstract void addToolTypes(Map<ToolType, Integer> var1, ItemStack var2);

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (this.toolClasses.isEmpty()) {
            this.addToolTypes(this.toolClasses, stack);
        }
        return this.toolClasses.keySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, PlayerEntity player, BlockState blockState) {
        if (this.toolClasses.isEmpty()) {
            this.addToolTypes(this.toolClasses, stack);
        }
        return this.toolClasses.getOrDefault(tool, -1);
    }
}

