/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChickenSuitUpdatePacket {
    private final int glideJumps;

    public ChickenSuitUpdatePacket() {
        this.glideJumps = -1;
    }

    public ChickenSuitUpdatePacket(int glideJumps) {
        this.glideJumps = glideJumps;
    }

    public static ChickenSuitUpdatePacket decode(PacketBuffer buf) {
        return new ChickenSuitUpdatePacket(buf.readInt());
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.glideJumps);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (this.glideJumps != -1) {
                    double d = -0.15 - 0.15 * (1.0 - (double)this.glideJumps / 5.0);
                    Vector3d mot = player.func_213322_ci();
                    if (mot.field_72448_b < d) {
                        player.func_213293_j(mot.field_72450_a, d, mot.field_72449_c);
                    }
                    player.field_70143_R = 0.0f;
                } else {
                    player.func_70664_aZ();
                    player.field_70143_R = 0.0f;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

