/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.util;

import com.grim3212.assorted.tools.AssortedTools;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class ConfigurableBlockStates {
    private final NonNullList<BlockState> loadedStates;

    private ConfigurableBlockStates(NonNullList<BlockState> loadedStates) {
        this.loadedStates = loadedStates;
    }

    public NonNullList<BlockState> getLoadedStates() {
        return this.loadedStates;
    }

    public static class Builder {
        private final NonNullList<ResourceLocation> blocks = NonNullList.func_191196_a();
        private final NonNullList<ResourceLocation> tags = NonNullList.func_191196_a();

        public void addBlock(ResourceLocation b) {
            this.blocks.add((Object)b);
        }

        public void addTag(ResourceLocation t) {
            this.tags.add((Object)t);
        }

        public Builder processString(List<String> input) {
            for (String in : input) {
                String s;
                AssortedTools.LOGGER.debug("Processing input : " + in);
                if (in == null || in.isEmpty()) continue;
                if (in.startsWith("tag|")) {
                    s = in.substring(4);
                    AssortedTools.LOGGER.debug("Add tag [" + s + "]");
                    this.addTag(new ResourceLocation(s));
                    continue;
                }
                if (in.startsWith("block|")) {
                    s = in.substring(6);
                    AssortedTools.LOGGER.debug("Add block [" + s + "]");
                    this.addBlock(new ResourceLocation(s));
                    continue;
                }
                AssortedTools.LOGGER.warn("Can't process input as a configurable block [" + in + "]");
            }
            return this;
        }

        public ConfigurableBlockStates build() {
            NonNullList states = NonNullList.func_191196_a();
            for (ResourceLocation b : this.blocks) {
                Block block = (Block)Registry.field_212618_g.func_82594_a(b);
                if (block != Blocks.field_150350_a) {
                    states.add((Object)block.func_176223_P());
                    continue;
                }
                AssortedTools.LOGGER.warn(b.toString() + " is not a valid block.");
            }
            for (ResourceLocation t : this.tags) {
                ITag foundTag = BlockTags.func_199896_a().func_199910_a(t);
                if (foundTag != null) {
                    states.addAll((Collection)foundTag.func_230236_b_().stream().map(Block::func_176223_P).collect(Collectors.toList()));
                    continue;
                }
                AssortedTools.LOGGER.warn(t.toString() + " is not a valid block tag.");
            }
            return new ConfigurableBlockStates(states);
        }
    }
}

