/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;

public class NBTHelper {
    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return !itemStack.func_190926_b() && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o(keyName);
        }
    }

    private static void initCompoundNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new CompoundNBT());
        }
    }

    private static void initCompoundNBT(CompoundNBT compound) {
        if (compound == null) {
            compound = new CompoundNBT();
        }
    }

    public static CompoundNBT getTag(CompoundNBT compound, String keyName) {
        if (compound == null || !compound.func_74764_b(keyName)) {
            return new CompoundNBT();
        }
        return compound.func_74775_l(keyName);
    }

    public static CompoundNBT getTag(ItemStack stack, String keyName) {
        NBTHelper.initCompoundNBT(stack);
        if (!stack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putTag(stack, keyName, new CompoundNBT());
        }
        return stack.func_77978_p().func_74775_l(keyName);
    }

    public static void putTag(ItemStack stack, String keyName, CompoundNBT compound) {
        NBTHelper.initCompoundNBT(stack);
        stack.func_77978_p().func_218657_a(keyName, (INBT)compound);
    }

    public static String getString(CompoundNBT compound, String keyName) {
        NBTHelper.initCompoundNBT(compound);
        if (compound == null || !compound.func_74764_b(keyName)) {
            NBTHelper.putString(compound, keyName, "");
        }
        return compound.func_74779_i(keyName);
    }

    public static void putString(CompoundNBT compound, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(compound);
        compound.func_74778_a(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putString(itemStack, keyName, "");
        }
        return itemStack.func_77978_p().func_74779_i(keyName);
    }

    public static void putString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74778_a(keyName, keyValue);
    }

    public static ItemStack putStringItemStack(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74778_a(keyName, keyValue);
        return itemStack;
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putBoolean(itemStack, keyName, false);
        }
        return itemStack.func_77978_p().func_74767_n(keyName);
    }

    public static void putBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74757_a(keyName, keyValue);
    }

    public static ItemStack putBooleanItemStack(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74757_a(keyName, keyValue);
        return itemStack;
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putByte(itemStack, keyName, (byte)0);
        }
        return itemStack.func_77978_p().func_74771_c(keyName);
    }

    public static void putByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74774_a(keyName, keyValue);
    }

    public static ItemStack putByteItemStack(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74774_a(keyName, keyValue);
        return itemStack;
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putShort(itemStack, keyName, (short)0);
        }
        return itemStack.func_77978_p().func_74765_d(keyName);
    }

    public static void putShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74777_a(keyName, keyValue);
    }

    public static ItemStack putShortItemStack(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74777_a(keyName, keyValue);
        return itemStack;
    }

    public static int getInt(CompoundNBT compound, String keyName) {
        NBTHelper.initCompoundNBT(compound);
        if (compound == null || !compound.func_74764_b(keyName)) {
            NBTHelper.putInt(compound, keyName, 0);
        }
        return compound.func_74762_e(keyName);
    }

    public static void putInt(CompoundNBT compound, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(compound);
        compound.func_74768_a(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putInt(itemStack, keyName, 0);
        }
        return itemStack.func_77978_p().func_74762_e(keyName);
    }

    public static int getInt(ItemStack itemStack, String keyName, int fallback) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putInt(itemStack, keyName, fallback);
        }
        return itemStack.func_77978_p().func_74762_e(keyName);
    }

    public static void putInt(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74768_a(keyName, keyValue);
    }

    public static ItemStack putIntItemStack(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74768_a(keyName, keyValue);
        return itemStack;
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putLong(itemStack, keyName, 0L);
        }
        return itemStack.func_77978_p().func_74763_f(keyName);
    }

    public static void putLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74772_a(keyName, keyValue);
    }

    public static ItemStack putLongItemStack(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74772_a(keyName, keyValue);
        return itemStack;
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.func_77978_p().func_74760_g(keyName);
    }

    public static void putFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74776_a(keyName, keyValue);
    }

    public static ItemStack putFloatItemStack(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74776_a(keyName, keyValue);
        return itemStack;
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putDouble(itemStack, keyName, 0.0);
        }
        return itemStack.func_77978_p().func_74769_h(keyName);
    }

    public static void putDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74780_a(keyName, keyValue);
    }

    public static ItemStack putDoubleItemStack(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74780_a(keyName, keyValue);
        return itemStack;
    }

    public static BlockPos getBlockPos(ItemStack itemStack, String keyName) {
        NBTHelper.initCompoundNBT(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.putBlockPos(itemStack, keyName, new BlockPos(0, 0, 0));
        }
        int[] pos = itemStack.func_77978_p().func_74759_k(keyName);
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public static BlockPos getBlockPos(CompoundNBT tag, String keyName) {
        NBTHelper.initCompoundNBT(tag);
        if (!tag.func_74764_b(keyName)) {
            NBTHelper.putBlockPos(tag, keyName, new BlockPos(0, 0, 0));
        }
        int[] pos = tag.func_74759_k(keyName);
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public static void putBlockPos(CompoundNBT tag, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(tag);
        tag.func_74783_a(keyName, new int[]{keyValue.func_177958_n(), keyValue.func_177956_o(), keyValue.func_177952_p()});
    }

    public static void putBlockPos(ItemStack itemStack, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74783_a(keyName, new int[]{keyValue.func_177958_n(), keyValue.func_177956_o(), keyValue.func_177952_p()});
    }

    public static ItemStack putBlockPosItemStack(ItemStack itemStack, String keyName, BlockPos keyValue) {
        NBTHelper.initCompoundNBT(itemStack);
        itemStack.func_77978_p().func_74783_a(keyName, new int[]{keyValue.func_177958_n(), keyValue.func_177956_o(), keyValue.func_177952_p()});
        return itemStack;
    }
}

