/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.common.util;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class WandCoord3D {
    public BlockPos pos;
    public BlockState state;

    private WandCoord3D() {
        this(BlockPos.field_177992_a, Blocks.field_150350_a.func_176223_P());
    }

    public WandCoord3D(BlockPos pos, BlockState state) {
        this.pos = pos;
        this.state = state;
    }

    public WandCoord3D(WandCoord3D a) {
        this(a.pos, a.state);
    }

    public WandCoord3D copy() {
        return new WandCoord3D(this);
    }

    public int getArea(WandCoord3D b) {
        return Math.abs(this.pos.func_177958_n() - b.pos.func_177958_n() + 1) * Math.abs(this.pos.func_177956_o() - b.pos.func_177956_o() + 1) * Math.abs(this.pos.func_177952_p() - b.pos.func_177952_p() + 1);
    }

    public double getDistance(WandCoord3D b) {
        double d3 = this.pos.func_177958_n() - b.pos.func_177958_n();
        double d4 = this.pos.func_177956_o() - b.pos.func_177956_o();
        double d5 = this.pos.func_177952_p() - b.pos.func_177952_p();
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public double getDistanceFlat(WandCoord3D b) {
        double d3 = this.pos.func_177958_n() - b.pos.func_177958_n();
        double d5 = this.pos.func_177952_p() - b.pos.func_177952_p();
        return MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5));
    }

    public int getFlatArea(WandCoord3D b) {
        return Math.abs(this.pos.func_177958_n() - b.pos.func_177958_n() + 1) * Math.abs(this.pos.func_177952_p() - b.pos.func_177952_p() + 1);
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setTo(WandCoord3D a) {
        this.setPos(a.pos);
    }

    public void writeToNBT(CompoundNBT compound, String key) {
        if (!compound.func_74764_b(key)) {
            compound.func_218657_a(key, (INBT)new CompoundNBT());
        }
        CompoundNBT coord = compound.func_74775_l(key);
        coord.func_74783_a("Pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        coord.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
    }

    public static void findEnds(WandCoord3D a, WandCoord3D b) {
        WandCoord3D n = new WandCoord3D();
        WandCoord3D m = new WandCoord3D();
        int nx = a.pos.func_177958_n() > b.pos.func_177958_n() ? b.pos.func_177958_n() : a.pos.func_177958_n();
        int ny = a.pos.func_177956_o() > b.pos.func_177956_o() ? b.pos.func_177956_o() : a.pos.func_177956_o();
        int nz = a.pos.func_177952_p() > b.pos.func_177952_p() ? b.pos.func_177952_p() : a.pos.func_177952_p();
        n.pos = new BlockPos(nx, ny, nz);
        int mx = a.pos.func_177958_n() < b.pos.func_177958_n() ? b.pos.func_177958_n() : a.pos.func_177958_n();
        int my = a.pos.func_177956_o() < b.pos.func_177956_o() ? b.pos.func_177956_o() : a.pos.func_177956_o();
        int mz = a.pos.func_177952_p() < b.pos.func_177952_p() ? b.pos.func_177952_p() : a.pos.func_177952_p();
        m.pos = new BlockPos(mx, my, mz);
        a.setTo(n);
        b.setTo(m);
    }

    public static int getArea(WandCoord3D a, WandCoord3D b) {
        return Math.abs(a.pos.func_177958_n() - b.pos.func_177958_n() + 1) * Math.abs(a.pos.func_177956_o() - b.pos.func_177956_o() + 1) * Math.abs(a.pos.func_177952_p() - b.pos.func_177952_p() + 1);
    }

    public static int getFlatArea(WandCoord3D a, WandCoord3D b) {
        return Math.abs(a.pos.func_177958_n() - b.pos.func_177958_n() + 1) * Math.abs(a.pos.func_177952_p() - b.pos.func_177952_p() + 1);
    }

    public static WandCoord3D getFromNBT(CompoundNBT compound, String key) {
        CompoundNBT nbt;
        if (compound.func_74764_b(key) && (nbt = compound.func_74775_l(key)).func_74764_b("Pos")) {
            int[] coord = nbt.func_74759_k("Pos");
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("BlockState"));
            if (coord.length == 3) {
                return new WandCoord3D(new BlockPos(coord[0], coord[1], coord[2]), state);
            }
        }
        return null;
    }
}

