/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.util.data.Bender;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;

public class Abilities {
    private static final ArrayList<Ability> abilities = new ArrayList();
    private static final Map<String, Ability> abilitiesByName = new HashMap<String, Ability>();

    @Nullable
    public static Ability get(String name) {
        return abilitiesByName.get(name);
    }

    @Nullable
    public static BendingAi getAi(String name, EntityLiving entity, Bender bender) {
        Ability ability = Abilities.get(name);
        if (ability != null) {
            return ability.getAi(entity, bender);
        }
        return null;
    }

    public static ArrayList<Ability> all() {
        return abilities;
    }

    public static void register(Ability ability) {
        abilities.add(ability);
        abilitiesByName.put(ability.getName(), ability);
    }

    public static List<Ability> getAbilitiesToRegister(UUID element) {
        ArrayList<Ability> abilityList = Abilities.all();
        List<Ability> elementAbilities = abilityList.stream().filter(a -> a.getBendingId() == element).sorted(Comparator.comparing(Ability::getBaseTier)).collect(Collectors.toList());
        return elementAbilities;
    }
}

