/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.bending.bending.DefaultAbilityAi;
import com.crowsofwar.avatar.bending.bending.combustion.Combustionbending;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.ice.Icebending;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.config.AbilityProperties;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.entity.mob.EntityHumanBender;
import com.crowsofwar.avatar.item.scroll.ItemScroll;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.packets.PacketCSyncAbilityProperties;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="avatarmod")
public abstract class Ability {
    public static final String CHI_COST = "chiCost";
    public static final String COOLDOWN = "cooldown";
    public static final String EXHAUSTION = "exhaustion";
    public static final String BURNOUT = "burnOut";
    public static final String BURNOUT_REGEN = "burnOutRecoverTick";
    public static final String XP_HIT = "xpOnHit";
    public static final String XP_USE = "xpOnUse";
    public static final String TIER = "tier";
    public static final String PARENT_TIER = "parentTier";
    public static final String PERFORMANCE = "performanceAmount";
    public static final String FIRE_TIME = "fireTime";
    public static final String LIFETIME = "lifeTime";
    public static final String SIZE = "size";
    public static final String SPEED = "speed";
    public static final String KNOCKBACK = "knockback";
    public static final String CHI_HIT = "chiOnHit";
    public static final String DAMAGE = "damage";
    public static final String DURATION = "duration";
    public static final String CHARGE_TIME = "chargeTime";
    public static final String RADIUS = "radius";
    public static final String EFFECT_RADIUS = "effectRadius";
    public static final String EFFECT_DAMAGE = "effectDamage";
    public static final String AIM_ASSIST = "aimAssist";
    public static final String RANGE = "range";
    public static final String COLOUR_R = "colouR";
    public static final String COLOUR_G = "colourG";
    public static final String COLOUR_B = "colourB";
    public static final String POTION_EFFECTS = "potionEffects";
    public static final String PUSH_REDSTONE = "pushRedstone";
    public static final String PUSH_IRONDOOR = "pushIronDoor";
    public static final String PUSH_STONE = "pushStoneButton";
    public static final String PUSH_IRON_TRAPDOOR = "pushIronTrapDoor";
    public static final String FIRE_R = "fireR";
    public static final String FIRE_G = "fireG";
    public static final String FIRE_B = "fireB";
    public static final String FADE_R = "fadeR";
    public static final String FADE_G = "fadeG";
    public static final String FADE_B = "fadeB";
    public static final String SMELTS = "smelts";
    public static final String SETS_FIRES = "setsFires";
    public static final String POWERRATING = "powerrating";
    public static final String EFFECT_LEVEl = "effectLevel";
    public static final String EFFECT_STRENGTH = "effectStrength";
    public static final String EFFECT_DURATION = "effectDuration";
    public static final String CHI_BOOST = "chiBoost";
    public static final String CHI_REGEN_BOOST = "chiRegenBoost";
    public static final String REGEN_LEVEL = "regenLevel";
    public static final String REGEN_DURATION = "regenDuration";
    public static final String RESISTANCE_LEVEL = "resistanceLevel";
    public static final String RESISTANCE_DURATION = "resistanceDuration";
    public static final String SLOWNESS_LEVEL = "slownessLevel";
    public static final String SLOWNESS_DURATION = "slownessDuration";
    public static final String SATURATION_LEVEL = "saturationLevel";
    public static final String SATURATION_DURATION = "saturationDuration";
    public static final String STRENGTH_LEVEL = "strengthLevel";
    public static final String STRENGTH_DURATION = "strengthDuration";
    public static final String SPEED_LEVEL = "speedLevel";
    public static final String SPEED_DURATION = "speedDuration";
    public static final String HEALTH_LEVEL = "healthLevel";
    public static final String HEALTH_DURATION = "healthDuration";
    public static final String JUMP_LEVEL = "jumpLevel";
    public static final String JUMP_DURATION = "jumpDuration";
    public static final String EXPLOSION_SIZE = "explosionSize";
    public static final String EXPLOSION_DAMAGE = "explosionDamage";
    public static final String MAX_SIZE = "maxSize";
    public static final String MAX_DAMAGE = "maxDamage";
    public static final String MAX_CHICOST = "maxChiCost";
    public static final String MAX_BURNOUT = "maxBurnout";
    public static final String MAX_EXHAUSTION = "maxExhaustion";
    public static final String MAX_COOLDOWN = "maxCooldown";
    public static final String JUMP_HEIGHT = "jumpHeight";
    public static final String STOP_SHOCKWAVE = "stopShockwave";
    public static final String GROUND_POUND = "groundPound";
    public static final String JUMPS = "numberOfJumps";
    public static final String FALL_ABSORPTION = "fallAbsorption";
    public static final String CHI_PERCENT = "chiPercentOnHit";
    public static final String CHI_PER_SECOND = "chiPerSecond";
    public static final String BURNOUT_HIT = "burnOutOnHit";
    public static final String MAX_HEALTH = "maxHealth";
    public static final String EXHAUSTION_HIT = "exhaustionOnHit";
    public static final String DESTROY_TIER = "destroyTier";
    public static final String REDIRECT_TIER = "redirectTier";
    public static final String ABSORB_FIRE = "absorbFires";
    public static final String ABSORB_TIER = "absorbTier";
    public static final String POWER_BOOST = "powerBoost";
    public static final String POWER_DURATION = "powerDuration";
    public static final int MAX_TIER = 7;
    private final UUID type;
    private final String name;
    private final Set<String> propertyKeys = new HashSet<String>();
    private final Set<String> booleanPropertyKeys = new HashSet<String>();
    public AbilityProperties properties;
    private AbilityProperties globalProperties;
    private Raytrace.Info raytrace;

    public Ability(UUID bendingType, String name) {
        this.type = bendingType;
        this.name = name;
        this.raytrace = new Raytrace.Info();
    }

    public static void syncProperties(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            Ability.clearProperties();
        } else {
            AbilityProperties.loadWorldSpecificAbilityProperties(player.field_70170_p);
            for (Ability ability : Abilities.all()) {
                if (ability.arePropertiesInitialised()) continue;
                ability.setProperties(ability.globalProperties);
            }
            ArrayList<Ability> abilities = Abilities.all();
            AvatarMod.network.sendToAll((IMessage)new PacketCSyncAbilityProperties((AbilityProperties[])abilities.stream().map(a -> a.properties).toArray(AbilityProperties[]::new)));
        }
    }

    public static void syncEntityProperties() {
        for (Ability ability : Abilities.all()) {
            if (ability.arePropertiesInitialised()) continue;
            ability.setProperties(ability.globalProperties);
        }
        ArrayList<Ability> abilities = Abilities.all();
        AvatarMod.network.sendToAll((IMessage)new PacketCSyncAbilityProperties((AbilityProperties[])abilities.stream().map(a -> a.properties).toArray(AbilityProperties[]::new)));
    }

    private static void clearProperties() {
        for (Ability ability : Abilities.all()) {
            ability.properties = null;
        }
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getWorld().field_73011_w.getDimension() != 0) {
                return;
            }
            Ability.clearProperties();
            AbilityProperties.loadWorldSpecificAbilityProperties(event.getWorld());
            for (Ability ability : Abilities.all()) {
                if (ability.arePropertiesInitialised()) continue;
                ability.setProperties(ability.globalProperties);
            }
        }
    }

    @SubscribeEvent
    public static void onClientDisconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Ability.clearProperties();
        for (Ability ability : Abilities.all()) {
            ability.setProperties(ability.globalProperties);
        }
    }

    public static boolean propertyEqualsInhibitor(String property) {
        return property.equals(CHI_COST) || property.equals(EXHAUSTION) || property.equals(COOLDOWN) || property.equals(BURNOUT) || property.equals(BURNOUT_HIT) || property.equals(CHI_PER_SECOND) || property.equals(CHI_PERCENT) || property.equals(EXHAUSTION_HIT);
    }

    public void init() {
        this.addProperties(TIER, CHI_COST, BURNOUT, BURNOUT_REGEN, COOLDOWN, EXHAUSTION);
        if (this.isProjectile() || this.isOffensive()) {
            this.addProperties(LIFETIME, SPEED, CHI_HIT, PERFORMANCE, XP_HIT, SIZE, KNOCKBACK);
            if (this.isOffensive()) {
                this.addProperties(DAMAGE);
            }
        }
        if (this.isBuff()) {
            this.addProperties(DURATION, XP_USE, POWERRATING);
        }
        if (this.isUtility()) {
            this.addProperties(XP_USE);
        }
        if (this.isChargeable()) {
            this.addProperties(CHARGE_TIME);
        }
        if (this.getBendingId() == Firebending.ID && this.isOffensive()) {
            this.addProperties(FIRE_TIME);
        }
        if (this.getBendingId() == Lightningbending.ID || this.getBendingId() == Sandbending.ID || this.getBendingId() == Combustionbending.ID || this.getBendingId() == Icebending.ID) {
            this.addProperties(PARENT_TIER);
        }
    }

    public final Number getProperty(String identifier, int abilityLevel) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties == null ? (Number)1 : (Number)this.properties.getBaseValue(identifier, abilityLevel, AbilityData.AbilityTreePath.MAIN);
    }

    public final Number getProperty(String identifier, int abilityLevel, AbilityData.AbilityTreePath path) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties == null ? (Number)1 : (Number)this.properties.getBaseValue(identifier, abilityLevel, path);
    }

    public final Number getProperty(String identifier) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties == null ? (Number)1 : (Number)this.properties.getBaseValue(identifier, 0, AbilityData.AbilityTreePath.MAIN);
    }

    public final Number getProperty(String identifier, AbilityContext ctx) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties == null ? (Number)1 : (Number)ctx.getAbilityData().modify(identifier, this.properties.getBaseValue(identifier, ctx.getLevel(), ctx.getDynamicPath()));
    }

    public final Number getProperty(String identifier, AbilityData data) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties == null ? (Number)1 : (Number)data.modify(identifier, this.properties.getBaseValue(identifier, data.getLevel(), data.getDynamicPath()));
    }

    public final boolean getBooleanProperty(String identifier, int abilityLevel) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties != null && this.properties.getBaseBooleanValue(identifier, abilityLevel, AbilityData.AbilityTreePath.MAIN);
    }

    public final boolean getBooleanProperty(String identifier, int abilityLevel, AbilityData.AbilityTreePath path) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties != null && this.properties.getBaseBooleanValue(identifier, abilityLevel, path);
    }

    public final boolean getBooleanProperty(String identifier) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties != null && this.properties.getBaseBooleanValue(identifier, 0, AbilityData.AbilityTreePath.MAIN);
    }

    public final boolean getBooleanProperty(String identifier, AbilityContext ctx) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties != null && this.properties.getBaseBooleanValue(identifier, ctx.getLevel(), ctx.getDynamicPath());
    }

    public final boolean getBooleanProperty(String identifier, AbilityData data) {
        if (this.properties == null) {
            Ability.syncEntityProperties();
        }
        return this.properties != null && this.properties.getBaseBooleanValue(identifier, data.getLevel(), data.getDynamicPath());
    }

    protected BendingStyle controller() {
        return BendingStyles.get(this.type);
    }

    public final UUID getBendingId() {
        return this.type;
    }

    public void execute(AbilityContext ctx) {
        if (ctx.getBenderEntity() instanceof EntityBender) {
            ((EntityBender)ctx.getBenderEntity()).modifyAbilities(this);
        }
    }

    public int getCooldown(AbilityContext ctx) {
        if (ctx.getBenderEntity() instanceof EntityPlayer && ((EntityPlayer)ctx.getBenderEntity()).func_184812_l_()) {
            return 0;
        }
        int coolDown = this.getProperty(COOLDOWN, ctx).intValue();
        coolDown = (int)((double)coolDown * ((2.0 - ctx.getAbilityData().getDamageMult()) * (double)(1.0f / ctx.getAbilityData().getXpModifier())));
        return (int)((float)coolDown * (1.0f + ctx.getAbilityData().getBurnOut() / 200.0f));
    }

    public float getBurnOut(AbilityContext ctx) {
        if (ctx.getBenderEntity() instanceof EntityPlayer && ((EntityPlayer)ctx.getBenderEntity()).func_184812_l_()) {
            return 0.0f;
        }
        float burnout = this.getProperty(BURNOUT, ctx).floatValue();
        burnout = (float)((double)burnout * ((2.0 - ctx.getAbilityData().getDamageMult()) * (double)(1.0f / ctx.getAbilityData().getXpModifier())));
        return burnout;
    }

    public float getExhaustion(AbilityContext ctx) {
        if (ctx.getBenderEntity() instanceof EntityPlayer && ((EntityPlayer)ctx.getBenderEntity()).func_184812_l_()) {
            return 0.0f;
        }
        float exhaustion = this.getProperty(EXHAUSTION, ctx).floatValue();
        exhaustion = (float)((double)exhaustion * ((2.0 - ctx.getAbilityData().getDamageMult()) * (double)(1.0f / ctx.getAbilityData().getXpModifier())));
        return exhaustion * (1.0f + ctx.getAbilityData().getBurnOut() / 100.0f);
    }

    public float getChiCost(AbilityContext ctx) {
        if (ctx.getBenderEntity() instanceof EntityPlayer && ((EntityPlayer)ctx.getBenderEntity()).func_184812_l_() || ctx.getBenderEntity() instanceof EntityHumanBender) {
            return 0.0f;
        }
        float chi = this.getProperty(CHI_COST, ctx).floatValue();
        chi = (float)((double)chi * ((2.0 - ctx.getAbilityData().getDamageMult()) * (double)(1.0f / ctx.getAbilityData().getXpModifier())));
        return chi * (1.0f + ctx.getAbilityData().getBurnOut() / 200.0f);
    }

    public int getCooldown(AbilityData data) {
        int coolDown = this.getProperty(COOLDOWN, data).intValue();
        coolDown = (int)((double)coolDown * ((2.0 - data.getDamageMult()) * (double)(1.0f / data.getXpModifier())));
        return (int)((float)coolDown * (1.0f + data.getBurnOut() / 200.0f));
    }

    public float getBurnOut(AbilityData data) {
        float burnout = this.getProperty(BURNOUT, data).floatValue();
        burnout = (float)((double)burnout * ((2.0 - data.getDamageMult()) * (double)(1.0f / data.getXpModifier())));
        return burnout;
    }

    public float getExhaustion(AbilityData data) {
        float exhaustion = this.getProperty(EXHAUSTION, data).floatValue();
        exhaustion = (float)((double)exhaustion * ((2.0 - data.getDamageMult()) * (double)(1.0f / data.getXpModifier())));
        return exhaustion * (1.0f + data.getBurnOut() / 100.0f);
    }

    public float getChiCost(AbilityData data) {
        float chi = this.getProperty(CHI_COST, data).floatValue();
        chi = (float)((double)chi * ((2.0 - data.getDamageMult()) * (double)(1.0f / data.getXpModifier())));
        return chi * (1.0f + data.getBurnOut() / 200.0f);
    }

    public boolean isBuff() {
        return false;
    }

    public boolean isUtility() {
        return false;
    }

    public boolean isChargeable() {
        return false;
    }

    public boolean isProjectile() {
        return false;
    }

    public boolean isOffensive() {
        return false;
    }

    protected void requireRaytrace(double range, boolean raycastLiquids) {
        this.raytrace = new Raytrace.Info(range, raycastLiquids);
    }

    public final Raytrace.Info getRaytrace() {
        return this.raytrace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisibleInRadial() {
        return true;
    }

    public int getBaseTier() {
        return this.getProperty(TIER, 0).intValue();
    }

    public int getCurrentTier(AbilityContext ctx) {
        return this.getProperty(TIER, ctx).intValue();
    }

    public int getCurrentParentTier(AbilityContext ctx) {
        return this.getProperty(PARENT_TIER, ctx).intValue();
    }

    public int getCurrentTier(AbilityData data) {
        return this.getProperty(TIER, data).intValue();
    }

    public int getCurrentParentTier(AbilityData data) {
        return this.getProperty(PARENT_TIER, data).intValue();
    }

    public BendingStyle getElement() {
        return BendingStyles.get(this.getBendingId());
    }

    public int getBaseParentTier() {
        if (this.getElement().getParentBendingId() != null) {
            return this.getProperty(PARENT_TIER, 0).intValue();
        }
        return 0;
    }

    public boolean isCompatibleScroll(ItemStack stack, AbilityContext ctx) {
        if (this.getBendingId() != null && stack.func_77973_b() instanceof ItemScroll) {
            Scrolls.ScrollType type = Scrolls.getTypeForStack(stack);
            assert (type != null);
            if (type.getBendingId() == this.getBendingId() || type == Scrolls.ScrollType.ALL) {
                return Scrolls.getTierForStack(stack) >= this.getCurrentTier(ctx);
            }
            if (this.getBaseParentTier() > 0 && Objects.requireNonNull(BendingStyles.get(this.getBendingId())).getParentBendingId() == type.getBendingId()) {
                return Scrolls.getTierForStack(stack) >= this.getCurrentParentTier(ctx);
            }
        }
        return false;
    }

    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new DefaultAbilityAi(this, entity, bender);
    }

    public final Ability addProperties(String ... keys) {
        if (this.arePropertiesInitialised()) {
            throw new IllegalStateException("Tried to add ability properties after they were initialised");
        }
        for (String key : keys) {
            if (!this.propertyKeys.contains(key)) continue;
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Tried to add a duplicate property key '" + key + "' to ability " + this.getName());
        }
        Collections.addAll(this.propertyKeys, keys);
        return this;
    }

    public final Ability addBooleanProperties(String ... keys) {
        if (this.arePropertiesInitialised()) {
            throw new IllegalStateException("Tried to add ability properties after they were initialised");
        }
        for (String key : keys) {
            if (!this.booleanPropertyKeys.contains(key)) continue;
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Tried to add a duplicate property key '" + key + "' to ability " + this.getName());
        }
        Collections.addAll(this.booleanPropertyKeys, keys);
        return this;
    }

    public final String[] getPropertyKeys() {
        return this.propertyKeys.toArray(new String[0]);
    }

    public final String[] getBooleanPropertyKeys() {
        return this.booleanPropertyKeys.toArray(new String[0]);
    }

    public final boolean arePropertiesInitialised() {
        return this.properties != null;
    }

    public void setProperties(@Nonnull AbilityProperties properties) {
        if (!this.arePropertiesInitialised()) {
            this.properties = properties;
            if (this.globalProperties == null) {
                this.globalProperties = properties;
            }
        }
    }

    public float powerModify(float val, AbilityData abilityData) {
        val = (float)((double)val * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
        return val;
    }
}

