/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class AbilityModifier {
    private final List<String> propertyNames;
    private final List<Number> propertyValues;
    private HashMap<String, Number> properties;
    private UUID id = UUID.fromString("55c88686-6fc1-4cf5-8a31-887702fb2d5e");

    public AbilityModifier() {
        this.properties = new HashMap();
        this.propertyNames = new ArrayList<String>();
        this.propertyValues = new ArrayList<Number>();
    }

    public AbilityModifier(HashMap<String, Number> properties) {
        this.properties = properties;
        this.propertyNames = new ArrayList<String>();
        this.propertyValues = new ArrayList<Number>();
        this.propertyNames.addAll(properties.keySet());
        this.propertyValues.addAll(properties.values());
    }

    public AbilityModifier(UUID id) {
        this.id = id;
        this.properties = new HashMap();
        this.propertyNames = new ArrayList<String>();
        this.propertyValues = new ArrayList<Number>();
    }

    public AbilityModifier(HashMap<String, Number> properties, UUID id) {
        this.properties = properties;
        this.id = id;
        this.propertyNames = new ArrayList<String>();
        this.propertyValues = new ArrayList<Number>();
        this.propertyNames.addAll(properties.keySet());
        this.propertyValues.addAll(properties.values());
    }

    public static AbilityModifier staticFromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        int size = buffer.func_150792_a();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            propertyNames.add(i, GoreCoreByteBufUtil.readString((ByteBuf)buffer));
        }
        size = buffer.func_150792_a();
        ArrayList<Float> propertyValues = new ArrayList<Float>();
        for (int i = 0; i < size; ++i) {
            propertyValues.add(i, Float.valueOf(buffer.readFloat()));
        }
        HashMap<String, Number> properties = new HashMap<String, Number>();
        for (int i = 0; i < propertyNames.size(); ++i) {
            properties.put((String)propertyNames.get(i), (Number)propertyValues.get(i));
        }
        return new AbilityModifier(properties, buffer.func_179253_g());
    }

    public static AbilityModifier staticFromNBT(NBTTagCompound nbt) {
        int size = nbt.func_74762_e("Property Name Size");
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            propertyNames.add(i, nbt.func_74779_i("Property Name " + (i + 1)));
        }
        size = nbt.func_74762_e("Property Value Size");
        ArrayList<Float> propertyValues = new ArrayList<Float>();
        for (int i = 0; i < size; ++i) {
            propertyValues.add(i, Float.valueOf(nbt.func_74760_g("Property Value " + (i + 1))));
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        for (int i = 0; i < size; ++i) {
            map.put((String)propertyNames.get(i), (Number)propertyValues.get(i));
        }
        return new AbilityModifier(map, nbt.func_186857_a("ID"));
    }

    public void addProperties(HashMap<String, Number> properties) {
        this.properties.putAll(properties);
        this.propertyNames.addAll(properties.keySet());
        this.propertyValues.addAll(properties.values());
    }

    public void removeProperty(String property) {
        Number num = this.properties.get(property);
        this.properties.remove(property);
        this.propertyNames.remove(property);
        this.propertyValues.remove(num);
    }

    public void addProperty(String propertyName, Number propertyValue) {
        this.properties.put(propertyName, propertyValue);
        this.propertyNames.add(propertyName);
        this.propertyValues.add(propertyValue);
    }

    public void clearPropertyList() {
        this.properties.clear();
    }

    public void clearProperties() {
        this.properties.clear();
        this.propertyNames.clear();
        this.propertyValues.clear();
    }

    public boolean hasProperty(String property) {
        return this.properties.containsKey(property);
    }

    public Number getProperty(String property) {
        return this.properties.getOrDefault(property, 1);
    }

    public UUID getID() {
        return this.id;
    }

    public void setID(UUID id) {
        this.id = id;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_150787_b(this.propertyNames.size());
        ArrayList<String> propertyNames = new ArrayList<String>(this.propertyNames);
        if (!propertyNames.isEmpty()) {
            for (String string : propertyNames) {
                GoreCoreByteBufUtil.writeString(buf, string);
            }
        }
        buffer.func_150787_b(this.propertyValues.size());
        ArrayList<Number> propertyValues = new ArrayList<Number>(this.propertyValues);
        if (!propertyValues.isEmpty()) {
            for (Number number : propertyValues) {
                buffer.writeFloat(number.floatValue());
            }
        }
        buffer.func_179252_a(this.getID());
    }

    public AbilityModifier fromBytes(ByteBuf buf) {
        int i;
        PacketBuffer buffer = new PacketBuffer(buf);
        this.clearProperties();
        int size = buffer.func_150792_a();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (size > 0) {
            for (int i2 = 0; i2 < size; ++i2) {
                propertyNames.add(i2, GoreCoreByteBufUtil.readString(buf));
            }
        }
        size = buffer.func_150792_a();
        ArrayList<Float> propertyValues = new ArrayList<Float>();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                propertyValues.add(i, Float.valueOf(buffer.readFloat()));
            }
        }
        if (!propertyNames.isEmpty() && !propertyValues.isEmpty()) {
            for (i = 0; i < propertyNames.size(); ++i) {
                this.addProperty((String)propertyNames.get(i), (Number)propertyValues.get(i));
            }
        }
        this.setID(buffer.func_179253_g());
        return this;
    }

    public void toNBT(NBTTagCompound nbt) {
        int i;
        nbt.func_74768_a("Property Name Size", this.propertyNames.size());
        for (i = 0; i < this.propertyNames.size(); ++i) {
            nbt.func_74778_a("Property Name " + (i + 1), this.propertyNames.get(i));
        }
        nbt.func_74768_a("Property Value Size", this.propertyValues.size());
        for (i = 0; i < this.propertyValues.size(); ++i) {
            nbt.func_74776_a("Property Value " + (i + 1), this.propertyValues.get(i).floatValue());
        }
        nbt.func_186854_a("ID", this.getID());
    }

    public AbilityModifier fromNBT(NBTTagCompound nbt) {
        int i;
        int size = nbt.func_74762_e("Property Name Size");
        this.propertyNames.clear();
        for (i = 0; i < size; ++i) {
            this.propertyNames.add(i, nbt.func_74779_i("Property Name " + (i + 1)));
        }
        size = nbt.func_74762_e("Property Value Size");
        this.propertyValues.clear();
        for (i = 0; i < size; ++i) {
            this.propertyValues.add(i, Float.valueOf(nbt.func_74760_g("Property Value " + (i + 1))));
        }
        this.setID(nbt.func_186857_a("ID"));
        return this;
    }
}

