/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.DataCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;

public class BattlePerformanceScore {
    public static final double SCORE_MOD_SMALL = 16.0;
    public static final double SCORE_MOD_MEDIUM = 30.0;
    public static final double SCORE_MOD_LARGE = 50.0;
    private final BendingData data;
    private double score;

    public BattlePerformanceScore(BendingData data) {
        this(data, 0.0);
    }

    public BattlePerformanceScore(BendingData data, double score) {
        this.data = data;
        this.score = score;
    }

    public static void addScore(EntityLivingBase entity, int amount) {
        BendingData bendingData = BendingData.getFromEntity(entity);
        if (bendingData != null) {
            bendingData.getPerformance().modifyScore(amount);
        }
    }

    public static void addSmallScore(EntityLivingBase entity) {
        BendingData bendingData = BendingData.getFromEntity(entity);
        if (bendingData != null) {
            bendingData.getPerformance().modifyScore(16.0);
        }
    }

    public static void addMediumScore(EntityLivingBase entity) {
        BendingData bendingData = BendingData.getFromEntity(entity);
        if (bendingData != null) {
            bendingData.getPerformance().modifyScore(30.0);
        }
    }

    public static void addLargeScore(EntityLivingBase entity) {
        BendingData bendingData = BendingData.getFromEntity(entity);
        if (bendingData != null) {
            bendingData.getPerformance().modifyScore(50.0);
        }
    }

    private static final double getScoreChangePerSecond(double currentScore) {
        double min = 1.0;
        double max = 4.0;
        double k = 3333.3333333333335;
        return -Math.signum(currentScore) * (currentScore * currentScore + k * 1.0) / k;
    }

    public void update() {
        double changePerSecond = BattlePerformanceScore.getScoreChangePerSecond(this.score);
        this.modifyScore(changePerSecond / 20.0);
    }

    public void modifyScore(double amount) {
        this.setScore(MathHelper.func_151237_a((double)(this.score + amount), (double)-500.0, (double)500.0));
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        if (this.score != score) {
            this.data.save(DataCategory.PERFORMANCE);
        }
        this.score = score;
    }
}

