/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.Vec3d;

public abstract class BendingAi
extends EntityAIBase {
    protected final Ability ability;
    protected final EntityLiving entity;
    protected final Bender bender;
    protected int timeExecuting;

    protected BendingAi(Ability ability, EntityLiving entity, Bender bender) {
        this.ability = ability;
        this.entity = entity;
        this.bender = bender;
        this.timeExecuting = 0;
    }

    public void func_75249_e() {
        this.timeExecuting = 0;
        this.startExec();
    }

    public boolean func_75253_b() {
        return this.applyCustomBehaviour();
    }

    public void func_75251_c() {
        this.timeExecuting = 0;
        this.cleanUp();
    }

    public boolean applyCustomBehaviour() {
        if (Arrays.stream(this.getAbilityTypes()).anyMatch(abilityType -> abilityType == AbilityType.PROJECTILE || abilityType == AbilityType.OFFENSIVE)) {
            if (this.entity.func_70638_az() == null) {
                return false;
            }
            this.lookAtAttackTarget();
            if (this.shouldExecAbility()) {
                this.execAbility();
            }
            for (StatusControl sc : this.getStatusControls()) {
                if (!this.shouldExecStatCtrl(sc)) continue;
                this.execStatusControl(sc);
            }
        } else if (Arrays.stream(this.getAbilityTypes()).anyMatch(abilityType -> abilityType == AbilityType.MOBILITY)) {
            Random rand = this.entity.field_70170_p.field_73012_v;
            if (this.shouldExecAbility()) {
                this.execAbility();
            }
            if (this.timeExecuting >= this.getWaitDuration()) {
                this.lookAtTarget(this.entity.func_174791_d().func_72441_c(rand.nextGaussian() / 2.0, (double)this.entity.func_70047_e() + rand.nextGaussian() / 2.0, rand.nextGaussian() / 2.0));
                for (StatusControl sc : this.getStatusControls()) {
                    if (!this.shouldExecStatCtrl(sc)) continue;
                    this.execStatusControl(sc);
                }
                return false;
            }
        } else {
            if (this.shouldExecAbility()) {
                this.execAbility();
            }
            for (StatusControl sc : this.getStatusControls()) {
                if (!this.shouldExecStatCtrl(sc)) continue;
                this.execStatusControl(sc);
            }
            return false;
        }
        if (this.timeExecuting >= this.getTotalDuration()) {
            this.cleanUp();
        }
        return this.timeExecuting < this.getTotalDuration();
    }

    public void func_75246_d() {
        super.func_75246_d();
        ++this.timeExecuting;
    }

    public final boolean func_75250_a() {
        EntityLivingBase target = this.entity.func_70638_az();
        boolean targetInRange = target == null || this.entity.func_70068_e((Entity)target) < (double)(this.getMaxTargetRange() * this.getMaxTargetRange()) && this.entity.func_70068_e((Entity)target) > (double)(this.getMinTargetRange() * this.getMinTargetRange());
        return targetInRange && this.shouldExec();
    }

    protected abstract boolean shouldExec();

    protected abstract void startExec();

    protected void execAbility() {
        if (Objects.requireNonNull(AbilityData.get((EntityLivingBase)this.entity, this.ability.getName())).getAbilityCooldown() <= 0) {
            this.bender.executeAbility(this.ability, false);
        }
    }

    protected void execStatusControl(StatusControl sc) {
        Raytrace.Result raytrace;
        BendingData data = this.bender.getData();
        if (data.hasStatusControl(sc) && sc.execute(new BendingContext(data, (EntityLivingBase)this.entity, this.bender, raytrace = Raytrace.getTargetBlock((EntityLivingBase)this.entity, this.ability.getRaytrace())))) {
            data.removeStatusControl(sc);
        }
    }

    public AbilityType[] getAbilityTypes() {
        return new AbilityType[]{AbilityType.PROJECTILE};
    }

    public float getMaxTargetRange() {
        return 8.0f;
    }

    public float getMinTargetRange() {
        return 2.0f;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void cleanUp() {
        for (StatusControl sc : this.getStatusControls()) {
            if (!this.bender.getData().hasStatusControl(sc)) continue;
            this.bender.getData().removeStatusControl(sc);
        }
    }

    public boolean shouldExecAbility() {
        return true;
    }

    public StatusControl[] getStatusControls() {
        return new StatusControl[0];
    }

    public boolean shouldExecStatCtrl(StatusControl statusControl) {
        return this.timeExecuting >= this.getWaitDuration();
    }

    public void lookAtAttackTarget() {
        if (this.entity.func_70638_az() != null) {
            EntityLivingBase target = this.entity.func_70638_az();
            Vector rotations = Vector.getRotationTo(Vector.getEntityPos((Entity)this.entity), Vector.getEntityPos((Entity)this.entity.func_70638_az()));
            this.entity.field_70177_z = (float)Math.toDegrees(rotations.y());
            this.entity.field_70125_A = (float)Math.toDegrees(rotations.x());
            this.entity.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, (float)(this.entity.func_184649_cE() * 5), (float)(this.entity.func_70646_bf() * 5));
        }
    }

    public void lookAtTarget(Vec3d target) {
        if (this.entity.func_70638_az() != null) {
            Vector rotations = Vector.getRotationTo(Vector.getEntityPos((Entity)this.entity), new Vector(target));
            this.entity.field_70177_z = (float)Math.toDegrees(rotations.y());
            this.entity.field_70125_A = (float)Math.toDegrees(rotations.x());
            this.entity.func_70671_ap().func_75650_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, (float)(this.entity.func_184649_cE() * 5), (float)(this.entity.func_70646_bf() * 5));
        }
    }

    public int getWaitDuration() {
        return 10;
    }

    public boolean isConstant() {
        return false;
    }

    public int getTotalDuration() {
        return 40;
    }

    public static enum AbilityType {
        PROJECTILE,
        OFFENSIVE,
        BUFF,
        UTILITY,
        MOBILITY,
        DEFENSIVE;

    }
}

