/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.BendingMenuInfo;
import com.crowsofwar.gorecore.util.GoreCoreNBTInterfaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public abstract class BendingStyle
implements GoreCoreNBTInterfaces.ReadableWritable {
    public static final GoreCoreNBTInterfaces.CreateFromNBT<BendingStyle> creator = new GoreCoreNBTInterfaces.CreateFromNBT<BendingStyle>(){

        @Override
        public BendingStyle create(NBTTagCompound nbt, Object[] methodsExtraData, Object[] extraData) {
            UUID id = nbt.func_186857_a("ControllerID");
            try {
                BendingStyle bc = BendingStyles.get(id);
                return bc;
            }
            catch (Exception e) {
                AvatarLog.error("Could not find bending controller from ID '" + id + "' - please check NBT data");
                e.printStackTrace();
                return null;
            }
        }
    };
    public static final GoreCoreNBTInterfaces.WriteToNBT<BendingStyle> writer = new GoreCoreNBTInterfaces.WriteToNBT<BendingStyle>(){

        @Override
        public void write(NBTTagCompound nbt, BendingStyle object, Object[] methodsExtraData, Object[] extraData) {
            nbt.func_186854_a("ControllerID", object.getId());
        }
    };
    public static final Random random = new Random();
    private final List<Ability> abilities = new ArrayList<Ability>();
    @Nullable
    private UUID parentBendingId;

    public void registerAbilities() {
        for (Ability ability : Abilities.getAbilitiesToRegister(this.getId())) {
            this.addAbility(ability);
        }
    }

    public boolean canEntityUse() {
        return true;
    }

    public BendingStyle() {
        this(null);
    }

    public BendingStyle(UUID parentBendingId) {
        this.parentBendingId = parentBendingId;
    }

    protected void addAbility(String abilityName) {
        this.abilities.add(Abilities.get(abilityName));
    }

    protected void addAbility(Ability ability) {
        this.abilities.add(ability);
    }

    public abstract BendingMenuInfo getRadialMenu();

    public abstract String getName();

    public int getTextColour() {
        return 0xFFFFFF;
    }

    public TextFormatting getTextFormattingColour() {
        return TextFormatting.WHITE;
    }

    public abstract UUID getId();

    public byte getNetworkId() {
        return BendingStyles.getNetworkId(this.getId());
    }

    public List<Ability> getAllAbilities() {
        return this.abilities;
    }

    public boolean isSpecialtyBending() {
        return this.parentBendingId != null;
    }

    public boolean isParentBending() {
        return this.parentBendingId == null;
    }

    public SoundEvent getRadialMenuSound() {
        return SoundEvents.field_187909_gi;
    }

    @Nullable
    public BendingStyle getBending(String UUID2) {
        if (this.getId().toString().equals(UUID2)) {
            return this;
        }
        return null;
    }

    @Nullable
    public UUID getParentBendingId() {
        return this.parentBendingId;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }
}

