/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BendingStyles {
    private static final List<BendingStyle> bendingStyles = new ArrayList<BendingStyle>();
    private static final Map<UUID, BendingStyle> bendingStylesById = new HashMap<UUID, BendingStyle>();
    private static final Map<String, BendingStyle> bendingStylesByName = new HashMap<String, BendingStyle>();
    private static final Map<UUID, Byte> networkIdByStyle = new HashMap<UUID, Byte>();
    private static final Map<Byte, UUID> networkIdToStyle = new HashMap<Byte, UUID>();
    private static byte nextNetworkId = 1;

    @Nullable
    public static BendingStyle get(@Nullable UUID id) {
        return bendingStylesById.get(id);
    }

    @Nullable
    public static BendingStyle get(String name) {
        return bendingStylesByName.get(name);
    }

    public static boolean has(UUID id) {
        return bendingStylesById.containsKey(id);
    }

    @Nullable
    public static String getName(UUID id) {
        BendingStyle bendingStyle = BendingStyles.get(id);
        return bendingStyle != null ? bendingStyle.getName() : null;
    }

    @Nullable
    public static byte getNetworkId(UUID id) {
        return networkIdByStyle.get(id);
    }

    @Nullable
    public static byte getNetworkId(BendingStyle style) {
        return BendingStyles.getNetworkId(style.getId());
    }

    public static BendingStyle get(byte networkId) {
        UUID id = networkIdToStyle.get(networkId);
        return BendingStyles.get(id);
    }

    public static List<BendingStyle> all() {
        return bendingStyles;
    }

    public static List<UUID> allIds() {
        return bendingStyles.stream().map(BendingStyle::getId).collect(Collectors.toList());
    }

    public static List<UUID> allMainIds() {
        return bendingStyles.stream().filter(style -> !style.isSpecialtyBending()).map(BendingStyle::getId).collect(Collectors.toList());
    }

    public static void register(BendingStyle bendingStyle) {
        bendingStyles.add(bendingStyle);
        bendingStylesById.put(bendingStyle.getId(), bendingStyle);
        bendingStylesByName.put(bendingStyle.getName(), bendingStyle);
        byte by = nextNetworkId;
        nextNetworkId = (byte)(by + 1);
        byte networkId = by;
        networkIdByStyle.put(bendingStyle.getId(), networkId);
        networkIdToStyle.put(networkId, bendingStyle.getId());
    }
}

