/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.PowerRatingModifier;
import com.crowsofwar.avatar.util.data.Vision;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;

public abstract class BuffPowerModifier
extends PowerRatingModifier {
    private boolean useSlipstreamShaders;
    private boolean useCleanseShaders;
    private boolean useRestoreShaders;
    private boolean useImmolateShaders;

    public BuffPowerModifier() {
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        this.useSlipstreamShaders = false;
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        this.useCleanseShaders = false;
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        this.useRestoreShaders = false;
        ConfigClient.CLIENT_CONFIG.shaderSettings.getClass();
        this.useImmolateShaders = false;
    }

    protected abstract Vision[] getVisions();

    protected abstract String getAbilityName();

    private Vision getVision(BendingContext ctx) {
        AbilityData abilityData = ctx.getData().getAbilityData(this.getAbilityName());
        if (!this.useSlipstreamShaders && abilityData.getAbility() == Abilities.get("slipstream")) {
            return null;
        }
        if (!this.useCleanseShaders && abilityData.getAbility() == Abilities.get("cleanse")) {
            return null;
        }
        if (!this.useRestoreShaders && abilityData.getAbility() == Abilities.get("restore")) {
            return null;
        }
        if (!this.useImmolateShaders && abilityData.getAbility() == Abilities.get("immolate")) {
            return null;
        }
        switch (abilityData.getLevel()) {
            case -1: 
            case 0: 
            case 1: {
                if (this.getVisions()[0] != null) {
                    return this.getVisions()[0];
                }
            }
            case 2: {
                if (this.getVisions()[1] == null) break;
                return this.getVisions()[1];
            }
        }
        if (this.getVisions()[2] != null) {
            return this.getVisions()[2];
        }
        return this.getVisions()[0];
    }

    @Override
    public boolean onUpdate(BendingContext ctx) {
        if (ctx.getData().getVision() == null && this.getVision(ctx) != null && this.getVisions()[0] != null && this.getVisions()[1] != null && this.getVisions()[2] != null) {
            ctx.getData().setVision(this.getVision(ctx));
        }
        return super.onUpdate(ctx);
    }

    @Override
    public void onRemoval(BendingContext ctx) {
        Vision[] visions = this.getVisions();
        Vision vision = ctx.getData().getVision();
        if (vision != null && visions != null) {
            if (vision == visions[0] || vision == visions[1] || vision == visions[2]) {
                ctx.getData().setVision(null);
            }
            super.onRemoval(ctx);
        }
    }
}

