/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SourceInfo {
    private IBlockState state;
    private World world;
    private int time;
    private BlockPos pos;

    public SourceInfo() {
        this.state = Blocks.field_150350_a.func_176223_P();
        this.time = -1;
        this.pos = new BlockPos(0, 0, 0);
    }

    public SourceInfo(IBlockState state, World world, int time, BlockPos pos) {
        this.state = state;
        this.world = world;
        this.time = time;
        this.pos = pos;
    }

    public void setState(IBlockState state) {
        this.state = state;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    public void writeToBytes(ByteBuf buf) {
        buf.writeInt(this.getTime());
        GoreCoreByteBufUtil.writeBlockPos(buf, this.pos);
        buf.writeInt(Block.func_176210_f((IBlockState)this.state));
    }

    public SourceInfo readFromBytes(ByteBuf buf) {
        this.setTime(buf.readInt());
        this.setBlockPos(GoreCoreByteBufUtil.readBlockPos(buf));
        this.setState(Block.func_176220_d((int)buf.readInt()));
        return this;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        int[] blockPos = new int[]{this.getBlockPos().func_177958_n(), this.getBlockPos().func_177956_o(), this.getBlockPos().func_177952_p()};
        nbt.func_74768_a("Block Time", this.time);
        nbt.func_74768_a("Block State", Block.func_176210_f((IBlockState)this.state));
        nbt.func_74783_a("Block Pos", blockPos);
    }

    public SourceInfo readFromNBT(NBTTagCompound nbt) {
        this.setTime(nbt.func_74762_e("Block Time"));
        this.setState(Block.func_176220_d((int)nbt.func_74762_e("Block State")));
        int[] blockPos = nbt.func_74759_k("Block Pos");
        if (blockPos.length > 2) {
            this.setBlockPos(new BlockPos(blockPos[0], blockPos[1], blockPos[2]));
        } else {
            this.setBlockPos(new BlockPos(0, 0, 0));
        }
        return this;
    }
}

