/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.network.packets.PacketSWallJump;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.MiscData;
import com.crowsofwar.gorecore.GoreCore;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="avatarmod")
public class WallJumpEvents {
    private static void tick(EntityPlayer player, World world, BendingData data) {
        MiscData miscData = data.getMiscData();
        Bender bender = Bender.get((EntityLivingBase)player);
        if (player == GoreCore.proxy.getClientSidePlayer() && bender.getWallJumpManager().canWallJump() && AvatarControl.CONTROL_JUMP.isPressed()) {
            if (bender.getWallJumpManager() != null && bender.getWallJumpManager().knowsWallJump() && world.field_72995_K) {
                List<Ability> abilities;
                BendingStyle style = BendingStyles.get(Airbending.ID);
                int totalLevel = 0;
                if (BendingData.getFromEntity((EntityLivingBase)player) != null && style != null) {
                    abilities = style.getAllAbilities();
                    abilities = abilities.stream().filter(ability -> AbilityData.get((EntityLivingBase)player, ability.getName()).getLevel() > -1).collect(Collectors.toList());
                    for (Ability ability2 : abilities) {
                        AbilityData aD = AbilityData.get((EntityLivingBase)player, ability2.getName());
                        if (aD.getLevel() <= -1) continue;
                        totalLevel += aD.getLevel() + 1;
                    }
                }
                abilities = style.getAllAbilities();
                int maxLevel = abilities.size() * 4;
                int level = Math.min(3, (int)((float)totalLevel / (float)maxLevel * 4.0f));
                float size = 1.25f + (float)level * 0.25f;
                for (int i = 0; i < 8 + AvatarUtils.getRandomNumberInRange(0, 4); ++i) {
                    ParticleBuilder.create(bender.getWallJumpManager().getWallJumpParticleType()).spawnEntity((Entity)player).clr(0.95f, 0.95f, 0.95f, 0.15f).pos(player.field_70165_t, player.func_174813_aQ().field_72338_b, player.field_70161_v).vel(world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0).time(10 + AvatarUtils.getRandomNumberInRange(0, 4)).scale(size).collide(true).spawn(world);
                }
            }
            AvatarMod.network.sendToServer((IMessage)new PacketSWallJump());
        }
        if (player.field_70122_E) {
            miscData.setWallJumping(false);
            miscData.setTimeInAir(0);
        } else {
            miscData.setTimeInAir(miscData.getTimeInAir() + 1);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        World world = player.field_70170_p;
        BendingData data = BendingData.getFromEntity((EntityLivingBase)player);
        if (data != null) {
            WallJumpEvents.tick(player, world, data);
        }
    }
}

