/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.air.AiAirBubble;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityAirBubble;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AbilityAirBubble
extends Ability {
    private static final String HOVER = "hover";

    public AbilityAirBubble() {
        super(Airbending.ID, "air_bubble");
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("chiPerSecond", "chiPercentOnHit", "burnOutOnHit", "exhaustionOnHit", "maxHealth", "size");
        this.addBooleanProperties(HOVER);
    }

    @Override
    public void execute(AbilityContext ctx) {
        boolean elytraOk;
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        BendingData data = ctx.getData();
        AbilityData abilityData = ctx.getAbilityData();
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        boolean bl = elytraOk = ConfigStats.STATS_CONFIG.allowAirBubbleElytra || chest.func_77973_b() != Items.field_185160_cR;
        if (!elytraOk) {
            ctx.getBender().sendMessage("avatar.airBubbleElytra");
        }
        if (!data.hasStatusControl(StatusControlController.BUBBLE_CONTRACT) && elytraOk) {
            if (!bender.consumeChi(this.getChiCost(ctx))) {
                return;
            }
            float health = this.getProperty("maxHealth", ctx).floatValue();
            float size = this.getProperty("size", ctx).floatValue();
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (health > 0.0f) {
                health = (float)((double)health * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            }
            EntityAirBubble bubble = new EntityAirBubble(world);
            bubble.setOwner(entity);
            bubble.func_70107_b(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
            bubble.setMaxHealth(health);
            bubble.setHealth(health);
            bubble.setSize(size);
            bubble.field_70177_z = entity.field_70177_z;
            bubble.field_70125_A = entity.field_70125_A;
            bubble.field_70179_y = 0.0;
            bubble.field_70181_x = 0.0;
            bubble.field_70159_w = 0.0;
            bubble.setAllowHovering(this.getBooleanProperty(HOVER, ctx));
            bubble.setAbility(this);
            bubble.setTier(this.getCurrentTier(ctx));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)bubble);
            }
            data.addStatusControl(StatusControlController.BUBBLE_EXPAND);
            data.addStatusControl(StatusControlController.BUBBLE_CONTRACT);
        }
        super.execute(ctx);
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 3;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiAirBubble(this, entity, bender);
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }
}

