/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.air.AiAirBurst;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AbilityAirBurst
extends Ability {
    public static final String PULL_ENEMIES = "pullsEnemies";
    public static final String BLINDNESS_LEVEL = "blindnessLevel";
    public static final String BLINDNESS_DURATION = "blindnessDuration";
    public static final String SLOWNESS_LEVEL = "slownessLevel";
    public static final String SLOWNESS_DURATION = "slownessDuration";
    public static final String WEAKNESS_LEVEL = "weaknessLevel";
    public static final String WEAKNESS_DURATION = "weaknessDuration";
    public static final String BLAST_LEVEL = "blastLevel";
    public static final String SLOW_MULT = "slowMult";

    public AbilityAirBurst() {
        super(Airbending.ID, "air_burst");
    }

    @Override
    public void init() {
        super.init();
        this.addProperties(BLINDNESS_LEVEL, BLINDNESS_DURATION, SLOWNESS_LEVEL, SLOWNESS_DURATION, WEAKNESS_LEVEL, WEAKNESS_DURATION, BLAST_LEVEL, "effectRadius", "effectDamage", SLOW_MULT);
        this.addBooleanProperties(PULL_ENEMIES, "potionEffects");
    }

    @Override
    public void execute(AbilityContext ctx) {
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        boolean hasAirCharge = data.hasStatusControl(StatusControlController.RELEASE_AIR_BURST);
        if (bender.consumeChi(this.getChiCost(ctx) / 4.0f) && !hasAirCharge) {
            data.addStatusControl(StatusControlController.CHARGE_AIR_BURST);
        } else if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() && !hasAirCharge) {
            data.addStatusControl(StatusControlController.CHARGE_AIR_BURST);
        }
        super.execute(ctx);
    }

    @Override
    public int getBaseTier() {
        return 4;
    }

    @Override
    public boolean isChargeable() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiAirBurst(this, entity, bender);
    }
}

