/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.air.AiAirGust;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityAirGust;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbilityAirGust
extends Ability {
    public static final String PIERCES_ENEMIES = "piercesEnemies";
    public static final String DESTROY_PROJECTILES = "destroyProjectiles";
    public static final String SLOW_PROJECTILES = "slowProjectiles";

    public AbilityAirGust() {
        super(Airbending.ID, "air_gust");
    }

    @Override
    public void init() {
        super.init();
        this.addBooleanProperties("pushIronTrapDoor", "pushIronDoor", "pushStoneButton", "pushRedstone", PIERCES_ENEMIES, DESTROY_PROJECTILES, SLOW_PROJECTILES);
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        Vector look = Vector.toRectangular(Math.toRadians(entity.field_70177_z), Math.toRadians(entity.field_70125_A));
        Vector pos = Vector.getEyePos((Entity)entity);
        float speed = this.getProperty("speed", ctx).floatValue();
        float size = this.getProperty("size", ctx).floatValue();
        int lifetime = this.getProperty("lifeTime", ctx).intValue();
        int performance = this.getProperty("performanceAmount", ctx).intValue();
        float push = this.getProperty("knockback", ctx).floatValue() / 2.0f;
        size = (float)((double)size * (ctx.getPowerRatingDamageMod() * (double)ctx.getAbilityData().getXpModifier()));
        speed = (float)((double)speed + 5.0 * ctx.getPowerRatingDamageMod() * (double)ctx.getAbilityData().getXpModifier());
        lifetime = (int)((double)lifetime + 5.0 * ctx.getPowerRatingDamageMod() * (double)ctx.getAbilityData().getXpModifier());
        push = (float)((double)push * (1.0 + 0.5 * ctx.getPowerRatingDamageMod() * (double)ctx.getAbilityData().getXpModifier()));
        if (bender.consumeChi(this.getChiCost(ctx))) {
            EntityAirGust gust = new EntityAirGust(world);
            gust.setVelocity(look.times(speed));
            gust.setPosition(pos.minusY(0.5));
            gust.setOwner(entity);
            gust.setEntitySize(size);
            gust.setDamage(0.0f);
            gust.setLifeTime(lifetime);
            gust.setPush(push / 1.25f);
            gust.field_70125_A = entity.field_70125_A;
            gust.field_70177_z = entity.field_70177_z;
            gust.setPerformanceAmount(performance);
            gust.setPushRedstone(this.getBooleanProperty("pushRedstone", ctx));
            gust.setPushStone(this.getBooleanProperty("pushStoneButton", ctx));
            gust.setPushIronDoor(this.getBooleanProperty("pushIronDoor", ctx));
            gust.setPushIronTrapDoor(this.getBooleanProperty("pushIronTrapDoor", ctx));
            gust.setDestroyProjectiles(this.getBooleanProperty(DESTROY_PROJECTILES, ctx));
            gust.setSlowProjectiles(this.getBooleanProperty(SLOW_PROJECTILES, ctx));
            gust.setPiercing(this.getBooleanProperty(PIERCES_ENEMIES, ctx));
            gust.setAbility(this);
            gust.setTier(this.getCurrentTier(ctx));
            gust.setChiHit(this.getProperty("chiOnHit", ctx).floatValue());
            gust.setXp(this.getProperty("xpOnHit", ctx).floatValue());
            gust.setBehaviour(new AirGustBehaviour());
            gust.setDamageSource("avatar_Air");
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)gust);
            }
            entity.func_184609_a(EnumHand.MAIN_HAND);
            if (world.field_72995_K) {
                for (double angle = 0.0; angle < 360.0; angle += (double)Math.max((int)(size * 15.0f), 15)) {
                    Vector position = Vector.getOrthogonalVector(entity.func_70040_Z(), angle, (double)(size / 20.0f));
                    position = position.plus(pos.minusY(0.05).plus(Vector.getLookRectangular((Entity)entity)));
                    Vector velocity = position.minus(pos.minusY(0.05).plus(Vector.getLookRectangular((Entity)entity))).normalize();
                    velocity = velocity.times(speed / 400.0f);
                    double spawnX = position.x();
                    double spawnY = position.y();
                    double spawnZ = position.z();
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.x(), world.field_73012_v.nextGaussian() / 80.0 + velocity.y(), world.field_73012_v.nextGaussian() / 80.0 + velocity.z()).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(0.95f, 0.95f, 0.95f, 0.05f).spawnEntity((Entity)entity).scale(size * (1.0f / size)).element(new Airbending()).collide(true).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.x(), world.field_73012_v.nextGaussian() / 80.0 + velocity.y(), world.field_73012_v.nextGaussian() / 80.0 + velocity.z()).time(10 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.05f).spawnEntity((Entity)entity).scale(size * (1.0f / size)).element(new Airbending()).collide(true).spawn(world);
                }
            }
            entity.func_184609_a(world.field_73012_v.nextBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            ctx.getAbilityData().setRegenBurnout(true);
            entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187631_bo, entity.func_184176_by(), 1.0f + (float)Math.max(ctx.getLevel(), 0) / 2.0f, 0.9f + world.field_73012_v.nextFloat() / 10.0f);
            super.execute(ctx);
        }
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiAirGust(this, entity, bender);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    public static class AirGustBehaviour
    extends OffensiveBehaviour {
        @Override
        public Behavior<EntityOffensive> onUpdate(EntityOffensive entity) {
            if (entity != null) {
                World world = entity.field_70170_p;
                if (world.field_72995_K && entity.getOwner() != null) {
                    int i;
                    for (i = 0; i < 4; ++i) {
                        Vec3d mid = AvatarEntityUtils.getMiddleOfEntity(entity);
                        double spawnX = mid.field_72450_a + world.field_73012_v.nextGaussian() / 20.0;
                        double spawnY = mid.field_72448_b + world.field_73012_v.nextGaussian() / 20.0;
                        double spawnZ = mid.field_72449_c + world.field_73012_v.nextGaussian() / 20.0;
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 25.0, world.field_73012_v.nextGaussian() / 25.0, world.field_73012_v.nextGaussian() / 25.0).time(4 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.05f).spawnEntity(entity).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 1.0f)).element(entity.getElement()).collide(true).spawn(world);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 45.0 + entity.field_70159_w, world.field_73012_v.nextGaussian() / 45.0 + entity.field_70181_x, world.field_73012_v.nextGaussian() / 45.0 + entity.field_70179_y).time(14 + AvatarUtils.getRandomNumberInRange(0, 10)).clr(0.95f, 0.95f, 0.95f, 0.05f).spawnEntity(entity).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 0.5f)).element(entity.getElement()).collide(true).spawn(world);
                    }
                    for (i = 0; i < 2; ++i) {
                        Vec3d pos = Vector.getOrthogonalVector(entity.func_70040_Z(), (double)((float)(i * 180) + (float)(entity.field_70173_aa % 360 * 20) * (1.0f / entity.getAvgSize())), (double)(entity.getAvgSize() / 1.5f)).toMinecraft();
                        Vec3d entityPos = AvatarEntityUtils.getMiddleOfEntity(entity);
                        pos = pos.func_178787_e(entityPos);
                        Vec3d velocity = pos.func_178788_d(entityPos).func_72432_b();
                        velocity = velocity.func_186678_a(AvatarUtils.getSqrMagnitude(entity.getVelocity()) / 400000.0);
                        double spawnX = pos.field_72450_a;
                        double spawnY = pos.field_72448_b;
                        double spawnZ = pos.field_72449_c;
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity(entity).scale(0.75f * entity.getAvgSize() * (1.0f / entity.getAvgSize())).element(new Airbending()).collide(true).collideParticles(true).spawn(world);
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(10 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity(entity).scale(0.75f * entity.getAvgSize() * (1.0f / entity.getAvgSize())).element(new Airbending()).collide(true).collideParticles(true).spawn(world);
                    }
                }
                entity.field_70159_w *= 0.95;
                entity.field_70181_x *= 0.95;
                entity.field_70179_y *= 0.95;
                if (entity.velocity().sqrMagnitude() < 0.25) {
                    entity.Dissipate();
                }
                float expansionRate = 0.0125f;
                entity.setEntitySize(entity.getAvgSize() + expansionRate);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

