/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class AbilityAirJump
extends Ability {
    public AbilityAirJump() {
        super(Airbending.ID, "air_jump");
    }

    @Override
    public boolean isUtility() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("jumpHeight", "numberOfJumps", "knockback", "effectRadius", "performanceAmount", "fallAbsorption", "xpOnHit", "powerrating", "duration", "chiOnHit");
        this.addBooleanProperties("groundPound");
    }

    @Override
    public void execute(AbilityContext ctx) {
        boolean onGround;
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        AbilityData abilityData = ctx.getAbilityData();
        boolean allowDoubleJump = abilityData.getUseNumber() < this.getProperty("numberOfJumps", ctx).intValue();
        List collideWithGround = world.func_184144_a((Entity)entity, entity.func_174813_aQ().func_72314_b(0.2, 0.5, 0.2));
        boolean bl = onGround = !collideWithGround.isEmpty() || entity.field_70124_G || world.func_180495_p(entity.func_180425_c()).func_177230_c() == Blocks.field_150321_G;
        if (!data.hasStatusControl(StatusControlController.AIR_JUMP) && bender.consumeChi(this.getChiCost(ctx) / 4.0f)) {
            data.addStatusControl(StatusControlController.AIR_JUMP);
            if (data.hasTickHandler(TickHandlerController.AIR_PARTICLE_SPAWNER) || allowDoubleJump && !onGround) {
                Raytrace.Result raytrace = Raytrace.getTargetBlock(ctx.getBenderEntity(), -1.0);
                if (StatusControlController.AIR_JUMP.execute(new BendingContext(data, ctx.getBenderEntity(), ctx.getBender(), raytrace)) && !ctx.getWorld().field_72995_K) {
                    data.removeStatusControl(StatusControlController.AIR_JUMP);
                }
            }
        }
        abilityData.setRegenBurnout(true);
        super.execute(ctx);
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }
}

