/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.air.AiAirblade;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityAirGust;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AbilityAirblade
extends Ability {
    public static final String NUMBER_OF_BLADES = "numberOfBlades";
    public static final String ANGLE = "angle";
    public static final String DESTROY_GRASS = "destroyGrass";
    public static final String BOOMERANG = "boomerAang";
    public static final String PIERCES = "pierces";

    public AbilityAirblade() {
        super(Airbending.ID, "airblade");
    }

    @Override
    public void init() {
        super.init();
        this.addProperties(NUMBER_OF_BLADES, ANGLE);
        this.addBooleanProperties(DESTROY_GRASS, BOOMERANG, PIERCES);
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        if (!bender.consumeChi(this.getChiCost(ctx))) {
            return;
        }
        AbilityData abilityData = ctx.getData().getAbilityData(this);
        float sizeMult = this.getProperty("size", ctx).floatValue();
        float damage = this.getProperty("damage", ctx).floatValue();
        float speed = this.getProperty("speed", ctx).floatValue() * 5.0f;
        float knockback = this.getProperty("knockback", ctx).floatValue();
        int lifetime = this.getProperty("lifeTime", ctx).intValue();
        int performance = this.getProperty("performanceAmount", ctx).intValue();
        int blades = this.getProperty(NUMBER_OF_BLADES, ctx).intValue();
        float angle = this.getProperty(ANGLE, ctx).floatValue();
        damage = (float)((double)damage * ((double)abilityData.getXpModifier() * ctx.getPowerRatingDamageMod()));
        sizeMult *= abilityData.getXpModifier();
        sizeMult = (float)((double)sizeMult * Math.max(0.25, bender.calcPowerRating(Airbending.ID) / 100.0 + 1.0));
        speed = (float)((double)speed * ((double)abilityData.getXpModifier() * ctx.getPowerRatingDamageMod()));
        knockback = (float)((double)knockback * ((double)abilityData.getXpModifier() * ctx.getPowerRatingDamageMod()));
        lifetime = (int)((double)lifetime * ((double)abilityData.getXpModifier() * ctx.getPowerRatingDamageMod()));
        Vector spawnAt = Vector.getEyePos((Entity)entity).minusY(sizeMult / 2.0f);
        for (int i = 0; i < this.getProperty(NUMBER_OF_BLADES, ctx).intValue(); ++i) {
            float yaw = entity.field_70177_z - (float)(blades / 2) * angle + (float)i * angle;
            Vector direction = Vector.toRectangular(Math.toRadians(yaw), Math.toRadians(entity.field_70125_A));
            EntityAirGust airblade = new EntityAirGust(world);
            airblade.func_70107_b(spawnAt.x(), spawnAt.y(), spawnAt.z());
            airblade.setAbility(Objects.requireNonNull(Abilities.get("airblade")));
            airblade.setVelocity(direction.times(speed));
            airblade.setDamage(damage);
            airblade.setDestroyGrass(this.getBooleanProperty(DESTROY_GRASS, ctx));
            airblade.setElement(new Airbending());
            airblade.setXp(this.getProperty("xpOnHit", ctx).floatValue());
            airblade.field_70125_A = entity.field_70125_A;
            airblade.field_70177_z = yaw;
            airblade.setPiercing(this.getBooleanProperty(PIERCES, ctx));
            airblade.setPush(knockback / 3.5f);
            airblade.setLifeTime(lifetime);
            airblade.setOwner(entity);
            airblade.setTier(this.getCurrentTier(ctx));
            airblade.setChiHit(this.getProperty("chiOnHit", ctx).floatValue());
            airblade.setAbility(this);
            airblade.setDamageSource("avatar_Air_airblade");
            if (this.getBooleanProperty(BOOMERANG, ctx)) {
                airblade.setEntitySize(sizeMult, 0.25f * sizeMult);
                airblade.setExpandedWidth(sizeMult / 10.0f);
                airblade.setExpandedHeight(sizeMult / 20.0f);
            } else {
                airblade.setExpandedHeight(sizeMult / 2.0f);
                airblade.setExpandedWidth(sizeMult / 4.0f);
                airblade.setEntitySize(sizeMult, 0.25f * sizeMult);
            }
            airblade.setBehaviour(new AirBladeBehaviour());
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)airblade);
            }
            entity.func_184609_a(world.field_73012_v.nextBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            abilityData.setRegenBurnout(true);
        }
        super.execute(ctx);
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiAirblade(this, entity, bender);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    public static class AirBladeBehaviour
    extends OffensiveBehaviour {
        @Override
        public Behavior<EntityOffensive> onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityAirGust && entity.getOwner() != null) {
                World world = entity.field_70170_p;
                AbilityData data = AbilityData.get(entity.getOwner(), entity.getAbility().getName());
                if (data != null && entity.getAbility() instanceof AbilityAirblade && entity.getAbility().getBooleanProperty(AbilityAirblade.BOOMERANG, data)) {
                    int lifetime = entity.getAbility().getProperty("lifeTime", data).intValue();
                    if (entity.field_70173_aa > lifetime / 4 && entity.field_70173_aa < lifetime / 2) {
                        entity.field_70159_w *= 0.75;
                        entity.field_70181_x *= 0.75;
                        entity.field_70179_y *= 0.75;
                    }
                    if ((double)entity.field_70173_aa > (double)lifetime / 1.5) {
                        entity.setVelocity(AvatarEntityUtils.getMiddleOfEntity((Entity)entity.getOwner()).func_178788_d(AvatarEntityUtils.getMiddleOfEntity(entity)).func_186678_a(0.25));
                    }
                    if (world.field_72995_K) {
                        for (double i = 0.0; i < 20.0; i += (double)(1.0f / entity.getWidth())) {
                            double spawnX = AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72450_a;
                            double spawnY = AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72448_b;
                            double spawnZ = AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72449_c;
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0).collide(true).time(3 + AvatarUtils.getRandomNumberInRange(0, 1)).clr(1.0f, 1.0f, 1.0f, 0.075f).scale(entity.getAvgSize() / 4.0f).element(entity.getElement()).spawnEntity(entity).spawn(world);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(AvatarEntityUtils.getMiddleOfEntity(entity)).vel(world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0).collide(true).time(3 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(0.8f, 0.8f, 0.8f, 0.075f).scale(entity.getAvgSize() / 2.0f).element(entity.getElement()).spin(entity.getWidth() * 2.0f, 0.1).spawnEntity(entity).spawn(world);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(AvatarEntityUtils.getMiddleOfEntity(entity)).vel(world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0).collide(true).time(6 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(1.0f, 1.0f, 1.0f, 0.1f).scale(entity.getAvgSize()).element(entity.getElement()).spin(entity.getWidth() * 2.0f, 0.1).spawnEntity(entity).spawn(world);
                        }
                    }
                } else {
                    if (world.field_72995_K && (entity.field_70173_aa % 2 == 0 || entity.field_70173_aa <= 2)) {
                        for (double i = -90.0; i <= 90.0; i += 20.0) {
                            Vec3d pos = AvatarEntityUtils.getMiddleOfEntity(entity);
                            Vec3d newDir = entity.func_70040_Z().func_186678_a((double)entity.getHeight() / 1.75 * Math.cos(Math.toRadians(i)));
                            pos = pos.func_178787_e(newDir);
                            pos = new Vec3d(pos.field_72450_a, pos.field_72448_b + (double)entity.getHeight() / 1.75 * Math.sin(Math.toRadians(i)), pos.field_72449_c);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(pos).vel(world.field_73012_v.nextGaussian() / 30.0, world.field_73012_v.nextGaussian() / 30.0, world.field_73012_v.nextGaussian() / 30.0).collide(true).time(12 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(0.95f, 95.0f, 0.95f, 0.2f).scale(entity.getWidth() * 1.5f).element(entity.getElement()).spawnEntity(entity).spawn(world);
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(pos).vel(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).collide(true).time(4 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(0.95f, 0.95f, 0.95f, 0.2f).scale(entity.getWidth() * 2.0f).spawnEntity(entity).element(entity.getElement()).spawn(world);
                        }
                    }
                    entity.field_70159_w *= 0.975;
                    entity.field_70181_x *= 0.975;
                    entity.field_70179_y *= 0.975;
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

