/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingAi;
import com.crowsofwar.avatar.bending.bending.air.AiCloudBall;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.entity.EntityCloudBall;
import com.crowsofwar.avatar.entity.data.CloudburstBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityCloudBurst
extends Ability {
    private static final String CHI_SMASH = "chiSmash";
    private static final String ABSORB = "absorb";

    public AbilityCloudBurst() {
        super(Airbending.ID, "cloudburst");
        this.requireRaytrace(2.5, false);
    }

    @Override
    public void init() {
        super.init();
        this.addBooleanProperties("pushIronTrapDoor", "pushIronDoor", "pushStoneButton", "pushRedstone", CHI_SMASH, ABSORB);
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        Bender bender = ctx.getBender();
        BendingData data = ctx.getData();
        AbilityData abilityData = ctx.getAbilityData();
        if (data.hasStatusControl(StatusControlController.THROW_CLOUDBURST)) {
            return;
        }
        if (bender.consumeChi(this.getChiCost(ctx) / 4.0f)) {
            Vector target;
            if (ctx.isLookingAtBlock()) {
                target = ctx.getLookPos();
            } else {
                Vector playerPos = Vector.getEyePos((Entity)entity);
                target = playerPos.plus(Vector.getLookRectangular((Entity)entity).times(2.5));
            }
            float damage = this.getProperty("damage", ctx).floatValue();
            int size = (int)(this.getProperty("size", ctx).floatValue() * 32.0f);
            float chiHit = this.getProperty("chiOnHit", ctx).floatValue();
            int lifetime = this.getProperty("lifeTime", ctx).intValue();
            float knockback = this.getProperty("knockback", ctx).floatValue() / 2.0f;
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (int)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            chiHit = (float)((double)chiHit * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            knockback = (float)((double)knockback * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            EntityCloudBall cloudball = new EntityCloudBall(world);
            if (target != null) {
                cloudball.setPosition(target);
            }
            cloudball.setOwner(entity);
            cloudball.setSize(size);
            cloudball.setPushStoneButton(this.getBooleanProperty("pushStoneButton", ctx));
            cloudball.setPushIronTrapDoor(this.getBooleanProperty("pushIronTrapDoor", ctx));
            cloudball.setPushIronDoor(this.getBooleanProperty("pushIronDoor", ctx));
            cloudball.setBehavior(new CloudburstBehavior.PlayerControlled());
            cloudball.setDamage(damage);
            cloudball.setXp(this.getProperty("xpOnHit", ctx).floatValue());
            cloudball.setAbsorb(this.getBooleanProperty(ABSORB, ctx));
            cloudball.setChiSmash(this.getBooleanProperty(CHI_SMASH, ctx));
            cloudball.setAbility(this);
            cloudball.setElement(new Airbending());
            cloudball.setChiHit(chiHit);
            cloudball.setDamageSource("avatar_Air");
            cloudball.setTier(this.getCurrentTier(ctx));
            cloudball.setLifeTime(lifetime);
            cloudball.setPush(knockback);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)cloudball);
            }
            data.addStatusControl(StatusControlController.THROW_CLOUDBURST);
        }
        super.execute(ctx);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 3;
    }

    @Override
    public BendingAi getAi(EntityLiving entity, Bender bender) {
        return new AiCloudBall(this, entity, bender);
    }

    @Override
    public int getCooldown(AbilityContext ctx) {
        return 0;
    }

    @Override
    public float getBurnOut(AbilityContext ctx) {
        return 0.0f;
    }

    @Override
    public float getExhaustion(AbilityContext ctx) {
        return 0.0f;
    }
}

