/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.air.powermods.SlipstreamPowerModifier;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class AbilitySlipstream
extends Ability {
    public static final String AIR_WALK = "walkOnAir";
    public static final String INVIS_CHANCE = "invisibleChance";

    public AbilitySlipstream() {
        super(Airbending.ID, "slipstream");
    }

    @Override
    public boolean isBuff() {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this.addProperties("strengthLevel", "strengthDuration", "speedLevel", "speedDuration", "jumpLevel", "jumpDuration", INVIS_CHANCE);
        this.addBooleanProperties(AIR_WALK);
    }

    @Override
    public void execute(AbilityContext ctx) {
        float chi;
        BendingData data = ctx.getData();
        AbilityData abilityData = data.getAbilityData(this);
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        if (bender.consumeChi(chi = this.getChiCost(ctx))) {
            float xp = this.getProperty("xpOnUse", ctx).floatValue();
            int duration = this.getProperty("duration", ctx).intValue();
            duration = (int)((double)duration * ((2.0 - abilityData.getDamageMult()) * (double)abilityData.getXpModifier()));
            int speedLevel = this.getProperty("speedLevel", ctx).intValue();
            int speedDuration = this.getProperty("speedDuration", ctx).intValue();
            int jumpLevel = this.getProperty("jumpLevel", ctx).intValue();
            int jumpDuration = this.getProperty("jumpDuration", ctx).intValue();
            int strengthLevel = this.getProperty("strengthLevel", ctx).intValue();
            int strengthDuration = this.getProperty("strengthDuration", ctx).intValue();
            speedDuration = (int)((double)speedDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            jumpDuration = (int)((double)jumpDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            strengthDuration = (int)((double)strengthDuration * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            if (this.getBooleanProperty(AIR_WALK, ctx)) {
                data.addTickHandler(TickHandlerController.SLIPSTREAM_WALK_HANDLER, ctx);
            }
            if (speedLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, speedDuration, speedLevel - 1, false, false));
            }
            if (jumpLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, jumpDuration, jumpLevel - 1, false, false));
            }
            if (strengthLevel > 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, strengthDuration, strengthLevel - 1, false, false));
            }
            SlipstreamPowerModifier modifier = new SlipstreamPowerModifier();
            modifier.setTicks(duration);
            Objects.requireNonNull(data.getPowerRatingManager(this.getBendingId())).addModifier(modifier, ctx);
            abilityData.addXp(xp);
        }
        abilityData.setRegenBurnout(true);
        super.execute(ctx);
    }

    @Override
    public int getBaseTier() {
        return 5;
    }
}

