/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigChi;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Chi;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AirbendingPerformanceChiBonus {
    @SubscribeEvent
    public static void onAirbenderUpdate(TickEvent.PlayerTickEvent e) {
        double performanceScore;
        BendingData data;
        Bender bender;
        EntityPlayer player = e.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && (bender = Bender.get((EntityLivingBase)player)) != null && (data = bender.getData()) != null && data.hasBendingId(Airbending.ID) && !player.func_184812_l_() && (performanceScore = data.getPerformance().getScore()) > 20.0) {
            double boostPct = AirbendingPerformanceChiBonus.getChiMultiplier(performanceScore) - 1.0;
            float availableChi = (float)((double)(ConfigChi.CHI_CONFIG.availablePerSecond / 20.0f) * boostPct);
            float totalChi = (float)((double)(ConfigChi.CHI_CONFIG.regenPerSecond / 20.0f) * boostPct / 2.0);
            Chi chi = data.chi();
            if (chi.getAvailableChi() < chi.getAvailableMaxChi()) {
                chi.changeAvailableChi(availableChi);
                chi.changeTotalChi(totalChi);
            }
        }
    }

    private static double getChiMultiplier(double performance) {
        if (performance > 0.0) {
            return 1.0 + performance / 150.0;
        }
        return 1.0 + performance / 300.0;
    }
}

