/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.powermods;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.BuffPowerModifier;
import com.crowsofwar.avatar.bending.bending.air.AbilitySlipstream;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Vision;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="avatarmod")
public class SlipstreamPowerModifier
extends BuffPowerModifier {
    @Override
    public double get(BendingContext ctx) {
        BendingData data = ctx.getData();
        AbilityData abilityData = data.getAbilityData(new AbilitySlipstream());
        AbilitySlipstream ability = (AbilitySlipstream)Abilities.get("slipstream");
        double modifier = 0.0;
        if (abilityData != null && ability != null) {
            modifier = ability.getProperty("powerrating", abilityData).doubleValue();
            modifier *= (double)abilityData.getXpModifier();
        }
        return modifier;
    }

    @Override
    public boolean onUpdate(BendingContext ctx) {
        AbilityData data = ctx.getData().getAbilityData("slipstream");
        EntityLivingBase entity = ctx.getBenderEntity();
        AbilitySlipstream slipstream = (AbilitySlipstream)Abilities.get("slipstream");
        if (slipstream != null && data != null) {
            if (entity.field_70173_aa % 15 == 0 && Math.random() < slipstream.getProperty("invisibleChance", data).doubleValue()) {
                PotionEffect effect = new PotionEffect(MobEffects.field_76441_p, 20, 0, false, false);
                entity.func_70690_d(effect);
            }
            World world = entity.field_70170_p;
            if (world.field_72995_K) {
                AxisAlignedBB boundingBox = entity.func_174813_aQ();
                double spawnX = boundingBox.field_72340_a + world.field_73012_v.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                double spawnY = boundingBox.field_72338_b + world.field_73012_v.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                double spawnZ = boundingBox.field_72339_c + world.field_73012_v.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0).time(12).clr(0.95f, 0.95f, 0.95f, 0.1f).scale((1.5f + (float)Math.min(data.getLevel(), 0) / 2.0f) * 2.0f).element(new Airbending()).spawn(world);
            }
        }
        return super.onUpdate(ctx);
    }

    @Override
    public void onRemoval(BendingContext ctx) {
        ctx.getBenderEntity().func_189654_d(false);
        super.onRemoval(ctx);
    }

    @Override
    protected Vision[] getVisions() {
        return new Vision[]{Vision.SLIPSTREAM_WEAK, Vision.SLIPSTREAM_MEDIUM, Vision.SLIPSTREAM_POWERFUL};
    }

    @Override
    protected String getAbilityName() {
        return "slipstream";
    }
}

