/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.air.AbilityAirJump;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.air.powermods.AirJumpPowerModifier;
import com.crowsofwar.avatar.bending.bending.air.tickhandlers.SmashGroundHandler;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StatCtrlAirJump
extends StatusControl {
    public StatCtrlAirJump() {
        super(0, AvatarControl.CONTROL_JUMP, StatusControl.CrosshairPosition.BELOW_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        boolean onGround;
        Bender bender = ctx.getBender();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        World world = ctx.getWorld();
        AbilityData abilityData = data.getAbilityData("air_jump");
        AbilityAirJump jump = (AbilityAirJump)Abilities.get("air_jump");
        if (jump == null) {
            return true;
        }
        boolean allowDoubleJump = abilityData.getUseNumber() < jump.getProperty("numberOfJumps", abilityData).intValue();
        List collideWithGround = world.func_184144_a((Entity)entity, entity.func_174813_aQ().func_72314_b(0.25, 0.625, 0.25));
        boolean bl = onGround = !collideWithGround.isEmpty() || entity.field_70124_G || world.func_180495_p(entity.func_180425_c()).func_177230_c() == Blocks.field_150321_G;
        if (onGround || entity instanceof EntityPlayer && GliderHelper.getIsGliderDeployed((EntityPlayer)entity) || allowDoubleJump) {
            double multiplier = jump.getProperty("jumpHeight", abilityData).floatValue() / 5.0f;
            double powerModifier = jump.getProperty("powerrating", abilityData).doubleValue();
            double powerDuration = jump.getProperty("duration", abilityData).doubleValue();
            float fallAbsorption = jump.getProperty("fallAbsorption", abilityData).floatValue();
            float speed = jump.getProperty("knockback", abilityData).floatValue() / 3.0f;
            float size = jump.getProperty("effectRadius", abilityData).floatValue();
            float chiCost = jump.getChiCost(abilityData);
            float exhaustion = jump.getExhaustion(abilityData);
            float burnout = jump.getBurnOut(abilityData);
            int cooldown = jump.getCooldown(abilityData);
            float chiOnHit = jump.getProperty("chiOnHit", abilityData).floatValue();
            chiOnHit = (float)((double)chiOnHit * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            speed = (float)((double)speed * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            data.getMiscData().setFallAbsorption(fallAbsorption);
            if (entity instanceof EntityBender || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                chiCost = 0.0f;
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
            }
            if (bender.consumeChi(chiCost) && abilityData.getAbilityCooldown() <= 0) {
                data.addTickHandler(TickHandlerController.AIR_PARTICLE_SPAWNER, ctx);
                if (jump.getBooleanProperty("groundPound", abilityData)) {
                    data.addTickHandler(TickHandlerController.SMASH_GROUND, ctx);
                }
                Vector velocity = Vector.getLookRectangular((Entity)entity);
                velocity = velocity.times(multiplier * 1.25);
                velocity = velocity.withY(Math.max(velocity.y(), 0.15));
                if (!world.field_72995_K) {
                    if (!onGround) {
                        velocity = velocity.times(0.875);
                        entity.field_70159_w = velocity.x();
                        entity.field_70181_x = velocity.y();
                        entity.field_70179_y = velocity.z();
                    } else {
                        entity.func_70024_g(velocity.x(), velocity.y(), velocity.z());
                    }
                }
                AvatarUtils.afterVelocityAdded((Entity)entity);
                entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187631_bo, SoundCategory.PLAYERS, 1.0f, 0.7f);
                AirJumpPowerModifier powerRatingModifier = new AirJumpPowerModifier(powerModifier);
                powerRatingModifier.setTicks((int)powerDuration);
                data.getPowerRatingManager(Airbending.ID).addModifier(powerRatingModifier, ctx);
                EntityShockwave wave = new EntityShockwave(world);
                wave.setDamage(0.0f);
                wave.setFireTime(0);
                wave.setRange(size);
                wave.setSpeed(speed);
                wave.setParticle(EnumParticleTypes.EXPLOSION_NORMAL);
                wave.setPerformanceAmount(10);
                wave.setKnockbackMult(new Vec3d(0.5, 0.2, 0.5));
                wave.setParticleAmount(2);
                wave.setDamageSource("avatar_Air_shockwave");
                wave.setAbility(jump);
                wave.setChiHit(chiOnHit);
                wave.setElement(new Airbending());
                wave.setParticleSpeed(speed / 60.0f);
                wave.setPosition(entity.func_174791_d().func_72441_c(0.0, 0.5, 0.0));
                wave.setOwner(entity);
                wave.setBehaviour(new SmashGroundHandler.AirGroundPoundShockwave());
                wave.setRenderNormal(false);
                wave.setKnockbackMult(new Vec3d((double)speed, (double)(speed * 2.0f), (double)speed));
                wave.setXp(jump.getProperty("xpOnHit", abilityData).floatValue());
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)wave);
                }
                abilityData.addXp(jump.getProperty("xpOnUse", abilityData).floatValue());
                abilityData.setUseNumber(abilityData.getUseNumber() + 1);
                if (abilityData.getUseNumber() == jump.getProperty("numberOfJumps", abilityData).intValue()) {
                    abilityData.addBurnout(burnout);
                    abilityData.setAbilityCooldown(cooldown);
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71020_j(exhaustion);
                    }
                }
                if (abilityData.getUseNumber() > jump.getProperty("numberOfJumps", abilityData).intValue()) {
                    abilityData.setUseNumber(1);
                }
                abilityData.setRegenBurnout(true);
                int numberOfParticles = (int)(size * 5.0f);
                double particleSpeed = speed / 4.0f;
                if (world.field_72995_K) {
                    for (int i = 0; i < numberOfParticles; ++i) {
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).collide(true).pos(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity).func_72441_c(0.0, 0.1, 0.0)).clr(0.95f, 0.95f, 0.95f, 0.1f).time(14 + AvatarUtils.getRandomNumberInRange(0, 4)).vel(world.field_73012_v.nextGaussian() * particleSpeed / 10.0, world.field_73012_v.nextGaussian() * particleSpeed / 20.0, world.field_73012_v.nextGaussian() * particleSpeed / 10.0).scale(1.0f + (float)particleSpeed).spawn(world);
                    }
                }
            } else {
                bender.sendMessage("avatar.abilityCooldown");
            }
            return true;
        }
        return false;
    }
}

