/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.statctrls;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.air.AbilityCloudBurst;
import com.crowsofwar.avatar.client.controls.AvatarControl;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityCloudBall;
import com.crowsofwar.avatar.entity.data.CloudburstBehavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class StatCtrlThrowCloudBall
extends StatusControl {
    public StatCtrlThrowCloudBall() {
        super(16, AvatarControl.CONTROL_LEFT_CLICK, StatusControl.CrosshairPosition.LEFT_OF_CROSSHAIR);
    }

    @Override
    public boolean execute(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        World world = ctx.getWorld();
        AbilityData abilityData = ctx.getData().getAbilityData("cloudburst");
        AbilityCloudBurst burst = (AbilityCloudBurst)Abilities.get("cloudburst");
        Bender bender = ctx.getBender();
        if (abilityData != null && burst != null) {
            double speed = burst.getProperty("speed", abilityData).floatValue() * 3.0f;
            float exhaustion = burst.getExhaustion(abilityData);
            float burnout = burst.getBurnOut(abilityData);
            int cooldown = burst.getCooldown(abilityData);
            float chiCost = burst.getChiCost(abilityData);
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = chiCost = (float)0;
                burnout = chiCost;
            }
            speed *= abilityData.getDamageMult() * (double)abilityData.getXpModifier();
            if (bender.consumeChi(chiCost)) {
                EntityCloudBall cloudBall = AvatarEntity.lookupControlledEntity(world, EntityCloudBall.class, entity);
                if (cloudBall != null) {
                    cloudBall.setBehavior(new CloudburstBehavior.Thrown());
                    cloudBall.setVelocity(Vector.getLookRectangular((Entity)entity).times(speed * 1.5));
                    abilityData.setAbilityCooldown(cooldown);
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71020_j(exhaustion);
                    }
                    abilityData.addBurnout(burnout);
                }
                abilityData.setRegenBurnout(true);
            }
        }
        return true;
    }
}

