/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.air.AbilityAirBurst;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityIcePrison;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntitySandPrison;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AirBurstHandler
extends TickHandler {
    public static final UUID AIRBURST_MOVEMENT_MODIFIER_ID = UUID.fromString("f82d325c-9828-11e8-9eb6-529269fb1459");

    public AirBurstHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        World world = ctx.getWorld();
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        AbilityData abilityData = ctx.getData().getAbilityData("air_burst");
        AbilityAirBurst burst = (AbilityAirBurst)Abilities.get("air_burst");
        boolean shouldRemove = false;
        if (abilityData != null && burst != null) {
            AxisAlignedBB box;
            List collided;
            float powerMod = (float)abilityData.getDamageMult();
            float xpMod = abilityData.getXpModifier();
            int duration = data.getTickHandlerDuration(this);
            float damage = burst.getProperty("effectDamage", abilityData).floatValue();
            float slowMult = burst.getProperty("slowMult", abilityData).floatValue();
            float knockBack = burst.getProperty("knockback", abilityData).floatValue() / 4.0f;
            float radius = burst.getProperty("effectRadius", abilityData).floatValue();
            float durationToFire = burst.getProperty("chargeTime", abilityData).intValue();
            double suction = 0.05;
            float speed = burst.getProperty("speed", abilityData).floatValue() / 5.0f;
            int performanceAmount = burst.getProperty("performanceAmount", abilityData).intValue();
            float exhaustion = burst.getExhaustion(abilityData);
            float burnout = burst.getBurnOut(abilityData);
            int cooldown = burst.getCooldown(abilityData);
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
            }
            float charge = Math.max((int)(3.0f * ((float)duration / durationToFire)) + 1, 1);
            charge = Math.min(charge, 4.0f);
            durationToFire *= 2.0f - powerMod;
            durationToFire -= xpMod * 10.0f;
            damage *= powerMod * xpMod;
            radius *= powerMod * xpMod;
            speed *= powerMod * xpMod;
            float movementMultiplier = (slowMult *= powerMod * xpMod) - 0.7f * MathHelper.func_76129_c((float)((float)duration / 40.0f));
            float shockwaveSpeed = knockBack *= powerMod * xpMod;
            damage = (float)((double)damage * (0.2 + 0.2 * (double)charge));
            radius = (float)((double)radius * (0.6 + 0.1 * (double)charge));
            knockBack = (float)((double)knockBack * (0.6 + 0.1 * (double)charge));
            speed *= 1.0f + charge / 4.0f;
            performanceAmount = (int)((double)performanceAmount * (0.2 + 0.2 * (double)charge));
            this.applyMovementModifier(entity, MathHelper.func_76131_a((float)movementMultiplier, (float)0.1f, (float)1.0f));
            double inverseRadius = (durationToFire - (float)duration) / 10.0f;
            suction -= (double)((float)duration / 400.0f);
            if (world.field_72995_K && (float)duration <= durationToFire) {
                for (int i = 0; i < 12; ++i) {
                    Vector lookpos = Vector.toRectangular(Math.toRadians(entity.field_70177_z + (float)(i * 30)), 0.0).times(inverseRadius).withY(entity.func_70047_e() / 2.0f);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity).func_178787_e(lookpos.toMinecraft())).collide(true).scale(abilityData.getXpModifier() * 0.85f * charge).vel(world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0, world.field_73012_v.nextGaussian() / 60.0).clr(0.975f, 0.975f, 0.975f, 0.05f).element(new Airbending()).spawn(world);
                }
            }
            world.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.25f * charge, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
            if (burst.getBooleanProperty("pullsEnemies", abilityData) && !(collided = world.func_175647_a(Entity.class, box = new AxisAlignedBB(entity.field_70165_t + (double)radius, entity.field_70163_u + (double)radius, entity.field_70161_v + (double)radius, entity.field_70165_t - (double)radius, entity.field_70163_u - (double)radius, entity.field_70161_v - (double)radius), entity1 -> entity1 != entity)).isEmpty()) {
                for (Entity e : collided) {
                    if (!e.func_70104_M() || !e.func_70067_L() || e == entity) continue;
                    this.pullEntities(e, (Entity)entity, suction);
                }
            }
            if (charge >= (float)burst.getProperty("blastLevel", abilityData).intValue()) {
                this.addStatCtrl(data);
                shouldRemove = true;
            }
            if (!data.hasStatusControl(StatusControlController.RELEASE_AIR_BURST) && bender.consumeChi(burst.getChiCost(abilityData))) {
                int particleController = abilityData.getLevel() > 0 ? 48 - 6 * Math.max(abilityData.getLevel(), 0) : 48;
                EntityShockwave shockwave = new EntityShockwave(world);
                shockwave.setOwner(entity);
                shockwave.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)entity));
                shockwave.setRenderNormal(false);
                shockwave.setElement(new Airbending());
                shockwave.setParticleSpeed(speed);
                shockwave.setDamageSource("avatar_Air_sphere_shockwave");
                shockwave.setKnockbackMult(new Vec3d((double)knockBack, (double)(knockBack / 2.0f), (double)knockBack));
                shockwave.setDamage(damage);
                shockwave.setParticleAmount(1);
                shockwave.setRange(radius);
                shockwave.setSphere(true);
                shockwave.setTier(burst.getCurrentTier(abilityData));
                shockwave.setXp(burst.getProperty("xpOnHit", abilityData).floatValue());
                shockwave.setPerformanceAmount(performanceAmount);
                shockwave.setParticleSpeed(Math.min(knockBack / shockwaveSpeed * 1.5f, shockwaveSpeed));
                shockwave.setParticleController(particleController);
                shockwave.setAbility(Objects.requireNonNull(Abilities.get("air_burst")));
                shockwave.setSpeed(speed / 2.0f);
                shockwave.setBehaviour(new AirburstShockwave());
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)shockwave);
                }
                abilityData.addBurnout(burnout);
                abilityData.setAbilityCooldown(cooldown);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71020_j(exhaustion);
                }
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(AIRBURST_MOVEMENT_MODIFIER_ID);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 0.5f);
                data.removeStatusControl(StatusControlController.SHOOT_AIR_BURST);
                return true;
            }
            return !data.hasStatusControl(StatusControlController.RELEASE_AIR_BURST) || shouldRemove && !data.hasStatusControl(StatusControlController.SHOOT_AIR_BURST);
        }
        data.removeStatusControl(StatusControlController.SHOOT_AIR_BURST);
        return true;
    }

    private void addStatCtrl(BendingData data) {
        if (!data.hasStatusControl(StatusControlController.SHOOT_AIR_BURST)) {
            data.addStatusControl(StatusControlController.SHOOT_AIR_BURST);
        }
    }

    private void applyMovementModifier(EntityLivingBase entity, float multiplier) {
        IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        moveSpeed.func_188479_b(AIRBURST_MOVEMENT_MODIFIER_ID);
        moveSpeed.func_111121_a(new AttributeModifier(AIRBURST_MOVEMENT_MODIFIER_ID, "Airburst charge modifier", (double)(multiplier - 1.0f), 1));
    }

    private void pullEntities(Entity collided, Entity attacker, double suction) {
        Vector velocity = Vector.getEntityPos(collided).minus(Vector.getEntityPos(attacker));
        velocity = velocity.times(suction).times(-1.0);
        double x = velocity.x();
        double y = velocity.y();
        double z = velocity.z();
        if (!collided.field_70170_p.field_72995_K) {
            collided.func_70024_g(x, y, z);
            if (collided instanceof AvatarEntity) {
                if (!(collided instanceof EntityWall || collided instanceof EntityWallSegment || collided instanceof EntityIcePrison || collided instanceof EntitySandPrison)) {
                    AvatarEntity avent = (AvatarEntity)collided;
                    avent.func_70024_g(x, y, z);
                }
                collided.field_70160_al = true;
                AvatarUtils.afterVelocityAdded(collided);
            }
        }
    }

    @Override
    public void onRemoved(BendingContext ctx) {
        super.onRemoved(ctx);
        AbilityData abilityData = AbilityData.get(ctx.getBenderEntity(), "air_burst");
        if (abilityData != null) {
            abilityData.setRegenBurnout(true);
        }
        if (ctx.getBenderEntity().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(AIRBURST_MOVEMENT_MODIFIER_ID) != null) {
            ctx.getBenderEntity().func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(AIRBURST_MOVEMENT_MODIFIER_ID);
        }
    }

    public static class AirburstShockwave
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityShockwave) {
                World world = entity.field_70170_p;
                if (world.field_72995_K && entity.field_70173_aa == 2) {
                    ConfigClient.CLIENT_CONFIG.airRenderSettings.getClass();
                    for (double theta = 0.0; theta <= 180.0; theta += 1.0) {
                        double dphi = (double)(((EntityShockwave)entity).getParticleController() - (float)((EntityShockwave)entity).getParticleAmount()) / Math.sin(Math.toRadians(theta));
                        for (double phi = 0.0; phi < 360.0; phi += dphi) {
                            double rphi = Math.toRadians(phi);
                            double rtheta = Math.toRadians(theta);
                            double x1 = (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(rphi) * Math.sin(rtheta);
                            double y1 = (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(rphi) * Math.sin(rtheta);
                            double z1 = (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(rtheta);
                            double xVel = x1 * entity.getParticleSpeed() * 0.375 + world.field_73012_v.nextGaussian() / 16.0;
                            double yVel = y1 * entity.getParticleSpeed() * 0.375 + world.field_73012_v.nextGaussian() / 16.0;
                            double zVel = z1 * entity.getParticleSpeed() * 0.375 + world.field_73012_v.nextGaussian() / 16.0;
                            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(x1 + entity.field_70165_t, y1 + entity.field_70163_u, z1 + entity.field_70161_v).vel(xVel, yVel, zVel).clr(0.95f, 0.95f, 0.95f, 0.05f).time(12 + AvatarUtils.getRandomNumberInRange(2, 4)).collide(true).scale((float)((double)0.325f + 0.5 * ((EntityShockwave)entity).getSpeed() * (double)((float)((EntityShockwave)entity).getRange()))).element(new Airbending()).spawnEntity((Entity)entity.getOwner()).spawn(world);
                        }
                    }
                    for (double i = 0.0; i < ((EntityShockwave)entity).getRange() + (double)((EntityShockwave)entity).getParticleAmount(); i += 0.5) {
                        Vec3d vel = new Vec3d(world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
                        vel = vel.func_186678_a((double)0.3f * entity.getParticleSpeed());
                        ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).vel(vel).clr(0.95f, 0.95f, 0.95f, 0.075f).time(8 + AvatarUtils.getRandomNumberInRange(0, 10)).collide(true).scale((float)((double)0.4f + (double)(0.575f * (float)((EntityShockwave)entity).getRange()) * ((EntityShockwave)entity).getSpeed())).element(new Airbending()).spawn(world);
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

