/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.air.AbilityAirBurst;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.air.tickhandlers.AirBurstHandler;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityAirGust;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ShootAirBurstHandler
extends TickHandler {
    public ShootAirBurstHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        AbilityAirBurst burst = (AbilityAirBurst)Abilities.get("air_burst");
        AbilityData abilityData = ctx.getData().getAbilityData("air_burst");
        int duration = ctx.getData().getTickHandlerDuration(this);
        Vector look = Vector.toRectangular(Math.toRadians(entity.field_70177_z), Math.toRadians(entity.field_70125_A));
        Vector pos = Vector.getEyePos((Entity)entity);
        if (burst != null && abilityData != null && bender.consumeChi(burst.getChiCost(abilityData))) {
            int durationToFire = burst.getProperty("chargeTime", abilityData).intValue();
            durationToFire = (int)((double)durationToFire * (2.0 - abilityData.getDamageMult()));
            durationToFire = (int)((float)durationToFire - abilityData.getXpModifier() * 10.0f);
            int lifetime = burst.getProperty("lifeTime", abilityData).intValue();
            float damage = burst.getProperty("damage", abilityData).floatValue();
            float speed = burst.getProperty("speed", abilityData).floatValue() * 5.0f;
            float size = burst.getProperty("size", abilityData).floatValue();
            int performance = burst.getProperty("performanceAmount", abilityData).intValue();
            float xp = burst.getProperty("xpOnHit", abilityData).intValue();
            float exhaustion = burst.getExhaustion(abilityData);
            float burnout = burst.getBurnOut(abilityData);
            int cooldown = burst.getCooldown(abilityData);
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                cooldown = 0;
                exhaustion = burnout = (float)0;
            }
            int charge = Math.max(3 * (duration / durationToFire) + 1, 1);
            charge = Math.min(charge, 4);
            size = (float)((double)size * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage = (float)((double)damage * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            speed = (float)((double)speed * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            lifetime = (int)((double)lifetime * (abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            damage = (float)((double)damage * (0.5 + 0.125 * (double)charge));
            size = (float)((double)size * (0.5 + 0.125 * (double)charge));
            speed = (float)((double)speed * (0.5 + 0.125 * (double)charge));
            lifetime = (int)((double)lifetime * (0.8 + 0.05 * (double)charge));
            EntityAirGust gust = new EntityAirGust(world);
            gust.setVelocity(look.times(speed));
            gust.setPosition(pos.minusY(0.5));
            gust.setOwner(entity);
            gust.setEntitySize(size);
            gust.setAbility(Objects.requireNonNull(Abilities.get("air_burst")));
            gust.setDamage(damage);
            gust.setChiHit((float)((double)burst.getProperty("chiOnHit", abilityData).floatValue() * abilityData.getDamageMult() * (double)abilityData.getXpModifier()));
            gust.setPerformanceAmount(performance);
            gust.setXp(xp);
            gust.setLifeTime(lifetime);
            gust.field_70125_A = entity.field_70125_A;
            gust.field_70177_z = entity.field_70177_z;
            gust.setPushStone(true);
            gust.setPushIronDoor(true);
            gust.setPushIronTrapDoor(true);
            gust.setDestroyProjectiles(true);
            gust.setDynamicSpreadingCollision(true);
            gust.setPush(speed / 20.0f);
            gust.setPiercing(abilityData.getLevel() >= 2);
            gust.setTier(burst.getCurrentTier(abilityData));
            gust.setBehaviour(new AirBurstBeamBehaviour());
            gust.setDamageSource("avatar_Air");
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)gust);
            }
            abilityData.addBurnout(burnout);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71020_j(exhaustion);
            }
            abilityData.setAbilityCooldown(cooldown);
            entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187631_bo, entity.func_184176_by(), 1.0f + (float)Math.max(abilityData.getLevel(), 0) / 2.0f, 0.9f + world.field_73012_v.nextFloat() / 10.0f);
            entity.field_70170_p.func_184133_a(null, new BlockPos((Entity)entity), SoundEvents.field_187752_dd, entity.func_184176_by(), 2.0f, 3.0f);
            AttributeModifier modifier = entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(AirBurstHandler.AIRBURST_MOVEMENT_MODIFIER_ID);
            if (modifier != null && entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(modifier)) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(modifier);
            }
        }
        ctx.getData().removeTickHandler(TickHandlerController.AIRBURST_CHARGE_HANDLER, ctx);
        ctx.getData().removeStatusControl(StatusControlController.CHARGE_AIR_BURST);
        return true;
    }

    @Override
    public void onRemoved(BendingContext ctx) {
        super.onRemoved(ctx);
        AbilityData abilityData = AbilityData.get(ctx.getBenderEntity(), "air_burst");
        if (abilityData != null) {
            abilityData.setRegenBurnout(true);
        }
    }

    public static class AirBurstBeamBehaviour
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            World world = entity.field_70170_p;
            if (world.field_72995_K && entity.getOwner() != null && entity instanceof EntityAirGust) {
                int i;
                for (i = 0; i < 4; ++i) {
                    Vec3d mid = AvatarEntityUtils.getMiddleOfEntity(entity);
                    double spawnX = mid.field_72450_a + world.field_73012_v.nextGaussian() / 20.0;
                    double spawnY = mid.field_72448_b + world.field_73012_v.nextGaussian() / 20.0;
                    double spawnZ = mid.field_72449_c + world.field_73012_v.nextGaussian() / 20.0;
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0).time(4 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.075f).spawnEntity(entity).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 1.0f)).element(entity.getElement()).collide(true).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 45.0 + entity.field_70159_w, world.field_73012_v.nextGaussian() / 45.0 + entity.field_70181_x, world.field_73012_v.nextGaussian() / 45.0 + entity.field_70179_y).time(14 + AvatarUtils.getRandomNumberInRange(0, 10)).clr(0.95f, 0.95f, 0.95f, 0.075f).spawnEntity(entity).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 0.5f)).element(entity.getElement()).collide(true).spawn(world);
                }
                for (i = 0; i < 2; ++i) {
                    Vec3d pos = Vector.getOrthogonalVector(entity.func_70040_Z(), (double)((float)(i * 180) + (float)(entity.field_70173_aa % 360 * 20) * (1.0f / entity.getAvgSize())), (double)(entity.getAvgSize() / 1.5f)).toMinecraft();
                    Vec3d entityPos = AvatarEntityUtils.getMiddleOfEntity(entity);
                    pos = pos.func_178787_e(entityPos);
                    Vec3d velocity = pos.func_178788_d(entityPos).func_72432_b();
                    velocity = velocity.func_186678_a(AvatarUtils.getSqrMagnitude(entity.getVelocity()) / 400000.0);
                    double spawnX = pos.field_72450_a;
                    double spawnY = pos.field_72448_b;
                    double spawnZ = pos.field_72449_c;
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity(entity).scale(0.75f * entity.getAvgSize() * (1.0f / entity.getAvgSize())).element(new Airbending()).collide(true).collideParticles(true).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, world.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(10 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity(entity).scale(0.75f * entity.getAvgSize() * (1.0f / entity.getAvgSize())).element(new Airbending()).collide(true).collideParticles(true).spawn(world);
                }
                for (double angle = 0.0; angle < 360.0; angle += (double)Math.max((int)(entity.getAvgSize() * 25.0f) + entity.field_70173_aa % 360 * 20, 20)) {
                    Vector position = Vector.getOrthogonalVector(entity.func_70040_Z(), angle, (double)entity.getAvgSize());
                    position = position.plus(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0);
                    position = position.plus(AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72450_a, AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72448_b, AvatarEntityUtils.getMiddleOfEntity((Entity)entity).field_72449_c);
                    double spawnX = position.x();
                    double spawnY = position.y();
                    double spawnZ = position.z();
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0).time(6 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.075f).spawnEntity((Entity)entity.getOwner()).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 0.25f)).element(entity.getElement()).collide(true).collideParticles(true).spawn(world);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0, world.field_73012_v.nextGaussian() / 45.0).time(10 + AvatarUtils.getRandomNumberInRange(0, 10)).clr(0.95f, 0.95f, 0.95f, 0.075f).spawnEntity((Entity)entity.getOwner()).scale(entity.getAvgSize() * (1.0f / entity.getAvgSize() + 0.25f)).element(entity.getElement()).collide(true).collideParticles(true).spawn(world);
                }
            }
            float expansionRate = 0.01f;
            if (entity.field_70173_aa % 4 == 0) {
                entity.setEntitySize(entity.getAvgSize() + expansionRate);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

