/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.air.tickhandlers;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SmashGroundHandler
extends TickHandler {
    public SmashGroundHandler(int id) {
        super(id);
    }

    @Override
    public boolean tick(BendingContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        if (entity.func_70090_H() || entity.field_70122_E || bender.isFlying()) {
            if (entity.field_70122_E) {
                this.smashEntity(entity);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.getSound(), this.getSoundCategory(), 4.0f, 0.5f);
            }
            return true;
        }
        return false;
    }

    protected void smashEntity(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        EntityShockwave shockwave = new EntityShockwave(world);
        shockwave.setDamage(this.getDamage());
        shockwave.setOwner(entity);
        shockwave.func_70107_b(entity.field_70165_t, entity.func_174813_aQ().field_72338_b + 0.4, entity.field_70161_v);
        shockwave.setKnockbackHeight(this.getKnockbackHeight());
        shockwave.setSpeed((float)this.getSpeed() / 4.0f);
        shockwave.setKnockbackMult(new Vec3d(2.0, 4.0, 2.0));
        shockwave.setRange((float)this.getRange());
        shockwave.setPush((float)(this.getSpeed() / 15.0));
        shockwave.setRenderNormal(false);
        shockwave.setElement(this.getElement());
        shockwave.setSphere(false);
        shockwave.setTier(this.getAbility().getCurrentTier(AbilityData.get(entity, this.getAbility().getName())));
        shockwave.setParticle(this.getParticle());
        shockwave.setParticleAmount(this.getParticleAmount());
        shockwave.setParticleSpeed((float)this.getParticleSpeed() / 4.0f);
        shockwave.setFireTime(this.fireTime());
        shockwave.setDamageSource(this.getDamageSource().func_76355_l() + "_shockwave");
        shockwave.setAbility(this.getAbility());
        shockwave.setParticleWaves(this.getParticleWaves());
        shockwave.setPerformanceAmount(this.getPerformanceAmount());
        shockwave.setRenderNormal(this.spawnNormalShockwave());
        shockwave.setBehaviour(this.getBehaviour());
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)shockwave);
        }
    }

    protected int fireTime() {
        return 0;
    }

    protected double getRange() {
        return 8.0;
    }

    protected EnumParticleTypes getParticle() {
        return EnumParticleTypes.EXPLOSION_NORMAL;
    }

    protected int getParticleWaves() {
        return (int)(this.getSpeed() * 3.0);
    }

    protected int getParticleAmount() {
        return 1;
    }

    protected Ability getAbility() {
        return Abilities.get("air_jump");
    }

    protected double getParticleSpeed() {
        return 0.1f;
    }

    protected double getSpeed() {
        return 6.0;
    }

    protected float getKnockbackHeight() {
        return 0.1f;
    }

    protected SoundEvent getSound() {
        return SoundEvents.field_187646_bt;
    }

    protected SoundCategory getSoundCategory() {
        return SoundCategory.BLOCKS;
    }

    protected int getPerformanceAmount() {
        return 10;
    }

    protected float getDamage() {
        return 6.0f;
    }

    protected DamageSource getDamageSource() {
        return AvatarDamageSource.AIR;
    }

    protected BendingStyle getElement() {
        return new Airbending();
    }

    protected boolean spawnNormalShockwave() {
        return false;
    }

    protected OffensiveBehaviour getBehaviour() {
        return new AirGroundPoundShockwave();
    }

    public static class AirGroundPoundShockwave
    extends OffensiveBehaviour {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            if (entity.field_70170_p.field_72995_K && entity instanceof EntityShockwave && entity.field_70173_aa <= ((EntityShockwave)entity).getParticleWaves()) {
                for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (((EntityShockwave)entity).getRange() * (double)((EntityShockwave)entity).getParticleAmount() * (double)entity.field_70173_aa * 0.25)) {
                    double x2 = entity.field_70165_t + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle);
                    double y2 = entity.func_174813_aQ().field_72338_b + 0.3;
                    double z2 = entity.field_70161_v + (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle);
                    Vector speed = new Vector((double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.sin(angle) * entity.getParticleSpeed(), entity.getParticleSpeed() / 2.0 * entity.field_70170_p.field_73012_v.nextGaussian(), (double)entity.field_70173_aa * ((EntityShockwave)entity).getSpeed() * Math.cos(angle) * entity.getParticleSpeed());
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).clr(0.95f, 0.95f, 0.95f, 0.15f).pos(x2, y2, z2).vel(speed.toMinecraft()).collide(true).collideParticles(true).scale((float)((EntityShockwave)entity).getSpeed() * 4.0f).time(8 + AvatarUtils.getRandomNumberInRange(0, 2)).spawn(entity.field_70170_p);
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

