/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.combustion;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.combustion.Combustionbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityExplosion
extends Ability {
    public AbilityExplosion() {
        super(Combustionbending.ID, "explosion");
    }

    @Override
    public void execute(AbilityContext ctx) {
        float chi;
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        float xp = 3.0f;
        float f = chi = ctx.getLevel() > 0 ? ConfigStats.STATS_CONFIG.chiExplosionUpgraded : ConfigStats.STATS_CONFIG.chiExplosion;
        if (bender.consumeChi(chi)) {
            Raytrace.Result hit = Raytrace.getTargetBlock(entity, 20.0);
            float explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize;
            explosionSize = (float)((double)explosionSize + ctx.getPowerRating() * 2.0 / 100.0);
            if (ctx.getLevel() == 1) {
                explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize * 1.25f;
            }
            if (ctx.getLevel() == 2) {
                hit = Raytrace.getTargetBlock(entity, 30.0);
                explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize * 1.5f;
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.FIRST)) {
                hit = Raytrace.getTargetBlock(entity, 200.0);
                explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize * 1.25f;
            }
            if (ctx.isMasterLevel(AbilityData.AbilityTreePath.SECOND)) {
                explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize * 3.0f;
            }
            if (hit.hitSomething()) {
                Vector hitAt = hit.getPosPrecise();
                world.func_72876_a((Entity)entity, hitAt.x(), hitAt.y(), hitAt.z(), explosionSize, false);
                if (ctx.getLevel() <= 0) {
                    data.getAbilityData("explosion").addXp(xp);
                }
                if (ctx.getLevel() == 1) {
                    data.getAbilityData("explosion").addXp(xp - 1.0f);
                }
                if (ctx.getLevel() == 2) {
                    data.getAbilityData("explosion").addXp(xp - 2.0f);
                }
            }
        }
    }

    @Override
    public int getBaseTier() {
        return 1;
    }

    @Override
    public int getBaseParentTier() {
        return 3;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isOffensive() {
        return true;
    }
}

