/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.bending.bending.combustion;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.combustion.Combustionbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityExplosionSpawner;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class AbilityExplosivePillar
extends Ability {
    public AbilityExplosivePillar() {
        super(Combustionbending.ID, "explosive_pillar");
    }

    @Override
    public void execute(AbilityContext ctx) {
        EntityLivingBase entity = ctx.getBenderEntity();
        BendingData data = ctx.getData();
        Bender bender = ctx.getBender();
        World world = ctx.getWorld();
        AbilityData abilityData = ctx.getData().getAbilityData(this);
        float xp = 4.0f;
        float ticks = 100.0f;
        float chi = ConfigStats.STATS_CONFIG.chiExplosivePillar;
        if (bender.consumeChi(chi)) {
            EntityExplosionSpawner spawner = new EntityExplosionSpawner(world);
            Vector look = Vector.toRectangular(Math.toRadians(entity.field_70177_z), 0.0);
            double mult = ctx.getLevel() >= 1 ? 10.0 : 8.0;
            spawner.setOwner(entity);
            spawner.setExplosionFrequency(10.0f);
            spawner.setExplosionStrength(1.0f);
            spawner.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            spawner.setVelocity(look.times(mult));
            spawner.maxTicks(ticks);
            if (abilityData.getLevel() == 1) {
                spawner.setOwner(entity);
                spawner.setExplosionFrequency(8.0f);
                spawner.setExplosionStrength(1.25f);
                spawner.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                spawner.setVelocity(look.times(mult));
                spawner.maxTicks(ticks * 1.5f);
                data.getAbilityData("explosive_pillar").addXp(xp - 1.0f);
            }
            if (abilityData.getLevel() == 2) {
                spawner.setOwner(entity);
                spawner.setExplosionFrequency(6.0f);
                spawner.setExplosionStrength(1.5f);
                spawner.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                spawner.setVelocity(look.times(mult));
                spawner.maxTicks(ticks * 2.0f);
                data.getAbilityData("explosive_pillar").addXp(xp - 2.0f);
            }
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                spawner.setOwner(entity);
                spawner.setExplosionFrequency(15.0f);
                spawner.setExplosionStrength(2.0f);
                spawner.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                spawner.setVelocity(look.times(mult));
                spawner.maxTicks(ticks * 2.5f);
            }
            data.getAbilityData("explosive_pillar").addXp(xp);
            if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                for (int i = 0; i < 3; ++i) {
                    Vector direction = Vector.toRectangular(Math.toRadians(entity.field_70177_z), 0.0);
                    Vector direction2 = Vector.toRectangular(Math.toRadians(entity.field_70177_z + 60.0f), 0.0);
                    Vector direction3 = Vector.toRectangular(Math.toRadians(entity.field_70177_z + 320.0f), 0.0);
                    EntityExplosionSpawner explosionSpawner = new EntityExplosionSpawner(world);
                    if (i == 0) {
                        explosionSpawner.setVelocity(direction.times(mult));
                    }
                    if (i == 1) {
                        explosionSpawner.setVelocity(direction2.times(mult));
                    }
                    if (i == 2) {
                        explosionSpawner.setVelocity(direction3.times(mult));
                    }
                    explosionSpawner.setOwner(entity);
                    explosionSpawner.setExplosionFrequency(3.0f);
                    explosionSpawner.setExplosionStrength(1.0f);
                    explosionSpawner.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    explosionSpawner.maxTicks(ticks * 1.5f);
                    explosionSpawner.setAbility(this);
                    world.func_72838_d((Entity)explosionSpawner);
                }
            }
            world.func_72838_d((Entity)spawner);
        }
    }

    @Override
    public boolean isOffensive() {
        return true;
    }

    @Override
    public int getBaseTier() {
        return 2;
    }

    @Override
    public int getBaseParentTier() {
        return 4;
    }
}

